/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.jdo;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.DeclarativeConstraint;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.database.SimpleConstraint;
import org.apache.maven.archiva.database.constraints.AbstractSimpleConstraint;
import org.apache.maven.archiva.model.CompoundKey;
import org.codehaus.plexus.jdo.JdoFactory;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class JdoAccess
implements Initializable,
InstanceLifecycleListener,
StoreLifecycleListener {
    private JdoFactory jdoFactory;
    private PersistenceManagerFactory pmf;

    public void initialize() throws InitializationException {
        this.pmf = this.jdoFactory.getPersistenceManagerFactory();
        this.pmf.addInstanceLifecycleListener((InstanceLifecycleListener)this, null);
    }

    public static void dumpObjectState(PrintStream out, Object o) {
        String STATE = "[STATE] ";
        String INDENT = "        ";
        if (o == null) {
            out.println("[STATE] Object is null.");
            return;
        }
        out.println("[STATE] Object " + o.getClass().getName());
        if (!(o instanceof PersistenceCapable)) {
            out.println("        is NOT PersistenceCapable (not a jdo object?)");
            return;
        }
        out.println("        is PersistenceCapable.");
        if (o instanceof Detachable) {
            out.println("        is Detachable");
        }
        out.println("        is new : " + Boolean.toString(JDOHelper.isNew((Object)o)));
        out.println("        is transactional : " + Boolean.toString(JDOHelper.isTransactional((Object)o)));
        out.println("        is deleted : " + Boolean.toString(JDOHelper.isDeleted((Object)o)));
        out.println("        is detached : " + Boolean.toString(JDOHelper.isDetached((Object)o)));
        out.println("        is dirty : " + Boolean.toString(JDOHelper.isDirty((Object)o)));
        out.println("        is persistent : " + Boolean.toString(JDOHelper.isPersistent((Object)o)));
        out.println("        object id : " + JDOHelper.getObjectId((Object)o));
    }

    public PersistenceManager getPersistenceManager() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        return pm;
    }

    public void enableCache(Class clazz) {
        DataStoreCache cache = this.pmf.getDataStoreCache();
        cache.pinAll(clazz, false);
    }

    public Object saveObject(Object object) {
        return this.saveObject(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveObject(Object object, String[] fetchGroups) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (JDOHelper.getObjectId((Object)object) != null && !JDOHelper.isDetached((Object)object)) {
                throw new JDOUserException("Existing object is not detached: " + object, object);
            }
            if (fetchGroups != null) {
                for (int i = 0; i >= fetchGroups.length; ++i) {
                    pm.getFetchPlan().addGroup(fetchGroups[i]);
                }
            }
            pm.makePersistent(object);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    public List getAllObjects(Class clazz) {
        return this.queryObjects(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryObjects(Class clazz, Constraint constraint) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            List result = null;
            result = constraint != null ? (constraint instanceof DeclarativeConstraint ? this.processConstraint(pm, clazz, (DeclarativeConstraint)constraint) : (constraint instanceof AbstractSimpleConstraint ? this.processConstraint(pm, (SimpleConstraint)constraint) : this.processUnconstrained(pm, clazz))) : this.processUnconstrained(pm, clazz);
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryObjects(SimpleConstraint constraint) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            ArrayList result = this.processConstraint(pm, constraint);
            if (constraint.isResultsPersistable()) {
                result = (List)pm.detachCopyAll((Collection)result);
            } else {
                ArrayList copiedResults = new ArrayList();
                copiedResults.addAll(result);
                result = copiedResults;
            }
            tx.commit();
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    private List processUnconstrained(PersistenceManager pm, Class clazz) {
        Extent extent = pm.getExtent(clazz, true);
        Query query = pm.newQuery(extent);
        return (List)query.execute();
    }

    private List processConstraint(PersistenceManager pm, SimpleConstraint constraint) {
        Query query = pm.newQuery(constraint.getSelectSql());
        if (constraint.getResultClass() == null) {
            throw new IllegalStateException("Unable to use a SimpleConstraint with a null result class.");
        }
        query.setResultClass(constraint.getResultClass());
        if (constraint.getFetchLimits() != null) {
            pm.getFetchPlan().addGroup(constraint.getFetchLimits());
        }
        if (constraint.getParameters() != null) {
            return this.processParameterizedQuery(query, constraint.getParameters());
        }
        return (List)query.execute();
    }

    private List processConstraint(PersistenceManager pm, Class clazz, DeclarativeConstraint constraint) {
        Extent extent = pm.getExtent(clazz, true);
        Query query = pm.newQuery(extent);
        if (constraint.getFilter() != null) {
            query.setFilter(constraint.getFilter());
        }
        if (constraint.getVariables() != null) {
            query.declareVariables(StringUtils.join((Object[])constraint.getVariables(), (String)";  "));
        }
        if (constraint.getSortColumn() != null) {
            String ordering = constraint.getSortColumn();
            if (constraint.getSortDirection() != null) {
                ordering = ordering + " " + constraint.getSortDirection();
            }
            query.setOrdering(ordering);
        }
        if (constraint.getFetchLimits() != null) {
            pm.getFetchPlan().addGroup(constraint.getFetchLimits());
        }
        if (constraint.getWhereCondition() != null) {
            query.setFilter(constraint.getWhereCondition());
        }
        if (constraint.getDeclaredImports() != null) {
            query.declareImports(StringUtils.join((Object[])constraint.getDeclaredImports(), (String)", "));
        }
        if (constraint.getRange() != null) {
            query.setRange((long)constraint.getRange()[0], (long)constraint.getRange()[1]);
        }
        if (constraint.getDeclaredParameters() != null) {
            if (constraint.getParameters() == null) {
                throw new JDOException("Unable to use query, there are declared parameters, but no parameter objects to use.");
            }
            if (constraint.getParameters().length != constraint.getDeclaredParameters().length) {
                throw new JDOException("Unable to use query, there are <" + constraint.getDeclaredParameters().length + "> declared parameters, yet there are <" + constraint.getParameters().length + "> parameter objects to use.  This should be equal.");
            }
            query.declareParameters(StringUtils.join((Object[])constraint.getDeclaredParameters(), (String)", "));
            return this.processParameterizedQuery(query, constraint.getParameters());
        }
        return (List)query.execute();
    }

    private List processParameterizedQuery(Query query, Object[] parameters) {
        switch (parameters.length) {
            case 1: {
                return (List)query.execute(parameters[0]);
            }
            case 2: {
                return (List)query.execute(parameters[0], parameters[1]);
            }
            case 3: {
                return (List)query.execute(parameters[0], parameters[1], parameters[2]);
            }
        }
        throw new JDOException("Unable to use more than 3 parameters.");
    }

    public Object getObjectById(Class clazz, Object id, String fetchGroup) throws ObjectNotFoundException, ArchivaDatabaseException {
        if (id == null) {
            throw new ObjectNotFoundException("Unable to get object '" + clazz.getName() + "' from jdo using null id.");
        }
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (fetchGroup != null) {
                pm.getFetchPlan().addGroup(fetchGroup);
            }
            Object objectId = null;
            objectId = id instanceof CompoundKey ? pm.newObjectIdInstance(clazz, (Object)id.toString()) : pm.newObjectIdInstance(clazz, id);
            Object object = pm.getObjectById(objectId);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        catch (JDOObjectNotFoundException e) {
            throw new ObjectNotFoundException("Unable to find Database Object [" + id + "] of type " + clazz.getName() + " using " + (fetchGroup == null ? "no fetch-group" : "a fetch-group of [" + fetchGroup + "]"), e, id);
        }
        catch (JDOException e) {
            throw new ArchivaDatabaseException("Error in JDO during get of Database object id [" + id + "] of type " + clazz.getName() + " using " + (fetchGroup == null ? "no fetch-group" : "a fetch-group of [" + fetchGroup + "]"), e);
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    public Object getObjectById(Class clazz, String id, String fetchGroup) throws ObjectNotFoundException, ArchivaDatabaseException {
        if (StringUtils.isEmpty((String)id)) {
            throw new ObjectNotFoundException("Unable to get object '" + clazz.getName() + "' from jdo using null/empty id.");
        }
        return this.getObjectById(clazz, (Object)id, fetchGroup);
    }

    public boolean objectExists(Object object) {
        return JDOHelper.getObjectId((Object)object) != null;
    }

    public boolean objectExistsById(Class clazz, String id) throws ArchivaDatabaseException {
        try {
            Object o = this.getObjectById(clazz, id, null);
            return o != null;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Object o) throws ArchivaDatabaseException {
        if (o == null) {
            throw new ArchivaDatabaseException("Unable to remove null object '" + o.getClass().getName() + "'");
        }
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            o = pm.getObjectById(pm.getObjectId(o));
            pm.deletePersistent(o);
            tx.commit();
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackIfActive(Transaction tx) {
        PersistenceManager pm = tx.getPersistenceManager();
        try {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            this.closePersistenceManager(pm);
        }
    }

    public void closePersistenceManager(PersistenceManager pm) {
        try {
            pm.close();
        }
        catch (JDOUserException jDOUserException) {
            // empty catch block
        }
    }

    public void postDelete(InstanceLifecycleEvent evt) {
        PersistenceCapable obj = (PersistenceCapable)evt.getSource();
        if (obj == null) {
            return;
        }
    }

    public void preDelete(InstanceLifecycleEvent evt) {
    }

    public void postStore(InstanceLifecycleEvent evt) {
    }

    public void preStore(InstanceLifecycleEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Class aClass) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Query query = pm.newQuery(aClass);
            query.deletePersistentAll();
            tx.commit();
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    public JdoFactory getJdoFactory() {
        return this.jdoFactory;
    }
}

