/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.jdo;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ArtifactDAO;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.database.jdo.JdoAccess;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.ArchivaArtifactModel;
import org.apache.maven.archiva.model.jpox.ArchivaArtifactModelKey;

public class JdoArtifactDAO
implements ArtifactDAO {
    private JdoAccess jdo;

    public ArchivaArtifact createArtifact(String groupId, String artifactId, String version, String classifier, String type) {
        ArchivaArtifact artifact;
        try {
            artifact = this.getArtifact(groupId, artifactId, version, classifier, type);
        }
        catch (ArchivaDatabaseException e) {
            artifact = new ArchivaArtifact(groupId, artifactId, version, classifier, type);
        }
        return artifact;
    }

    public ArchivaArtifact getArtifact(String groupId, String artifactId, String version, String classifier, String type) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaArtifactModelKey key = new ArchivaArtifactModelKey();
        key.setGroupId(groupId);
        key.setArtifactId(artifactId);
        key.setVersion(version);
        key.setClassifier(classifier);
        key.setType(type);
        ArchivaArtifactModel model = (ArchivaArtifactModel)this.jdo.getObjectById(ArchivaArtifactModel.class, key, null);
        return new ArchivaArtifact(model);
    }

    public List queryArtifacts(Constraint constraint) throws ObjectNotFoundException, ArchivaDatabaseException {
        List results = this.jdo.queryObjects(ArchivaArtifactModel.class, constraint);
        if (results == null || results.isEmpty()) {
            return results;
        }
        ArrayList<ArchivaArtifact> ret = new ArrayList<ArchivaArtifact>();
        for (ArchivaArtifactModel model : results) {
            ret.add(new ArchivaArtifact(model));
        }
        return ret;
    }

    public ArchivaArtifact saveArtifact(ArchivaArtifact artifact) throws ArchivaDatabaseException {
        ArchivaArtifactModel model = (ArchivaArtifactModel)this.jdo.saveObject(artifact.getModel());
        if (model == null) {
            return null;
        }
        return new ArchivaArtifact(model);
    }

    public void deleteArtifact(ArchivaArtifact artifact) throws ArchivaDatabaseException {
        this.jdo.removeObject(artifact.getModel());
    }
}

