/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.jdo;

import java.util.List;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.database.ProjectModelDAO;
import org.apache.maven.archiva.database.jdo.JdoAccess;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.jpox.ArchivaProjectModelKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdoProjectModelDAO
implements ProjectModelDAO {
    private JdoAccess jdo;

    @Override
    public ArchivaProjectModel createProjectModel(String groupId, String artifactId, String version) {
        ArchivaProjectModel model;
        try {
            model = this.getProjectModel(groupId, artifactId, version);
        }
        catch (ArchivaDatabaseException e) {
            model = new ArchivaProjectModel();
            model.setGroupId(groupId);
            model.setArtifactId(artifactId);
            model.setVersion(version);
        }
        return model;
    }

    @Override
    public ArchivaProjectModel getProjectModel(String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaProjectModelKey key = new ArchivaProjectModelKey();
        key.groupId = groupId;
        key.artifactId = artifactId;
        key.version = version;
        return (ArchivaProjectModel)this.jdo.getObjectById(ArchivaProjectModel.class, key, null);
    }

    @Override
    public List<ArchivaProjectModel> queryProjectModels(Constraint constraint) throws ObjectNotFoundException, ArchivaDatabaseException {
        return this.jdo.queryObjects(ArchivaProjectModel.class, constraint);
    }

    @Override
    public ArchivaProjectModel saveProjectModel(ArchivaProjectModel model) throws ArchivaDatabaseException {
        return (ArchivaProjectModel)this.jdo.saveObject(model);
    }

    @Override
    public void deleteProjectModel(ArchivaProjectModel model) throws ArchivaDatabaseException {
        this.jdo.removeObject(model);
    }
}

