/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.project;

import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.VersionedReference;
import org.apache.maven.archiva.repository.project.ProjectModelException;
import org.apache.maven.archiva.repository.project.ProjectModelResolver;

public class DatabaseProjectModelResolver
implements ProjectModelResolver {
    private ArchivaDAO dao;

    public ArchivaProjectModel resolveProjectModel(VersionedReference reference) throws ProjectModelException {
        try {
            ArchivaProjectModel model = this.dao.getProjectModelDAO().getProjectModel(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
            return model;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (ArchivaDatabaseException e) {
            return null;
        }
    }
}

