/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.updater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.OrPredicate;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.DatabaseScanningConfiguration;
import org.apache.maven.archiva.consumers.DatabaseCleanupConsumer;
import org.apache.maven.archiva.consumers.DatabaseUnprocessedArtifactConsumer;
import org.apache.maven.archiva.consumers.functors.PermanentConsumerPredicate;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class DatabaseConsumers
implements Initializable {
    private ArchivaConfiguration archivaConfiguration;
    private List availableUnprocessedConsumers;
    private List availableCleanupConsumers;
    private Predicate selectedCleanupConsumers;
    private Predicate selectedUnprocessedConsumers;

    public void initialize() throws InitializationException {
        PermanentConsumerPredicate permanentConsumers = new PermanentConsumerPredicate();
        this.selectedCleanupConsumers = new OrPredicate((Predicate)permanentConsumers, (Predicate)new SelectedCleanupConsumersPredicate());
        this.selectedUnprocessedConsumers = new OrPredicate((Predicate)permanentConsumers, (Predicate)new SelectedUnprocessedConsumersPredicate());
    }

    public List getSelectedUnprocessedConsumers() {
        ArrayList ret = new ArrayList();
        ret.addAll(CollectionUtils.select((Collection)this.availableUnprocessedConsumers, (Predicate)this.selectedUnprocessedConsumers));
        return ret;
    }

    public List getSelectedCleanupConsumers() {
        ArrayList ret = new ArrayList();
        ret.addAll(CollectionUtils.select((Collection)this.availableCleanupConsumers, (Predicate)this.selectedCleanupConsumers));
        return ret;
    }

    public List getAvailableUnprocessedConsumers() {
        return Collections.unmodifiableList(this.availableUnprocessedConsumers);
    }

    public List getAvailableCleanupConsumers() {
        return Collections.unmodifiableList(this.availableCleanupConsumers);
    }

    class SelectedCleanupConsumersPredicate
    implements Predicate {
        SelectedCleanupConsumersPredicate() {
        }

        public boolean evaluate(Object object) {
            boolean satisfies = false;
            if (object instanceof DatabaseCleanupConsumer) {
                DatabaseCleanupConsumer consumer = (DatabaseCleanupConsumer)object;
                DatabaseScanningConfiguration config = DatabaseConsumers.this.archivaConfiguration.getConfiguration().getDatabaseScanning();
                return config.getCleanupConsumers().contains(consumer.getId());
            }
            return satisfies;
        }
    }

    class SelectedUnprocessedConsumersPredicate
    implements Predicate {
        SelectedUnprocessedConsumersPredicate() {
        }

        public boolean evaluate(Object object) {
            boolean satisfies = false;
            if (object instanceof DatabaseUnprocessedArtifactConsumer) {
                DatabaseUnprocessedArtifactConsumer consumer = (DatabaseUnprocessedArtifactConsumer)object;
                DatabaseScanningConfiguration config = DatabaseConsumers.this.archivaConfiguration.getConfiguration().getDatabaseScanning();
                return config.getUnprocessedConsumers().contains(consumer.getId());
            }
            return satisfies;
        }
    }
}

