/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.browsing;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowsingResults {
    private String selectedGroupId;
    private String selectedArtifactId;
    private List<String> selectedRepositoryIds = null;
    private List<String> groupIds = null;
    private List<String> artifacts = null;
    private List<String> versions = null;

    public BrowsingResults() {
    }

    public BrowsingResults(String groupId) {
        this.selectedGroupId = groupId;
    }

    public BrowsingResults(String groupId, String artifactId) {
        this.selectedGroupId = groupId;
        this.selectedArtifactId = artifactId;
    }

    public List<String> getArtifacts() {
        return this.artifacts;
    }

    public List<String> getGroupIds() {
        return this.groupIds;
    }

    public String getSelectedArtifactId() {
        return this.selectedArtifactId;
    }

    public String getSelectedGroupId() {
        return this.selectedGroupId;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public boolean hasArtifacts() {
        return CollectionUtils.isNotEmpty(this.artifacts);
    }

    public boolean hasGroupIds() {
        return CollectionUtils.isNotEmpty(this.groupIds);
    }

    public boolean hasVersions() {
        return CollectionUtils.isNotEmpty(this.versions);
    }

    public void setArtifacts(List<String> artifacts) {
        this.artifacts = artifacts;
    }

    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public void setVersions(List<String> versions) {
        this.versions = versions;
    }

    public List<String> getSelectedRepositoryIds() {
        return this.selectedRepositoryIds;
    }

    public void setSelectedRepositoryIds(List<String> selectedRepositoryIds) {
        this.selectedRepositoryIds = selectedRepositoryIds;
    }
}

