/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.browsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupIdFilter {
    private static final String GROUP_SEPARATOR = ".";

    public static List<String> filterGroups(List<String> groups) {
        GroupTreeNode tree = GroupIdFilter.buildGroupTree(groups);
        return GroupIdFilter.collateGroups(tree);
    }

    public static GroupTreeNode buildGroupTree(List<String> groups) {
        GroupTreeNode rootNode = new GroupTreeNode();
        for (String groupId : groups) {
            StringTokenizer tok = new StringTokenizer(groupId, GROUP_SEPARATOR);
            GroupTreeNode node = rootNode;
            while (tok.hasMoreTokens()) {
                String part = tok.nextToken();
                if (!node.getChildren().containsKey(part)) {
                    GroupTreeNode newNode = new GroupTreeNode(part, node);
                    node.addChild(newNode);
                    node = newNode;
                    continue;
                }
                node = node.getChildren().get(part);
            }
        }
        return rootNode;
    }

    private static List<String> collateGroups(GroupTreeNode rootNode) {
        ArrayList<String> groups = new ArrayList<String>();
        for (GroupTreeNode node : rootNode.getChildren().values()) {
            while (node.getChildren().size() == 1) {
                node = node.getChildren().values().iterator().next();
            }
            groups.add(node.getFullName());
        }
        return groups;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupTreeNode {
        private final String name;
        private final String fullName;
        private final Map<String, GroupTreeNode> children = new TreeMap<String, GroupTreeNode>();

        GroupTreeNode() {
            this.name = null;
            this.fullName = null;
        }

        GroupTreeNode(String name, GroupTreeNode parent) {
            this.name = name;
            this.fullName = parent.fullName != null ? parent.fullName + GroupIdFilter.GROUP_SEPARATOR + name : name;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.fullName;
        }

        public Map<String, GroupTreeNode> getChildren() {
            return this.children;
        }

        public void addChild(GroupTreeNode newNode) {
            this.children.put(newNode.name, newNode);
        }
    }
}

