/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.AbstractDeclarativeConstraint;

public class ArtifactsByChecksumConstraint
extends AbstractDeclarativeConstraint
implements Constraint {
    private String whereClause;
    public static final String SHA1 = "SHA1";
    public static final String MD5 = "MD5";

    public ArtifactsByChecksumConstraint(String desiredChecksum) {
        this(desiredChecksum, null);
    }

    public ArtifactsByChecksumConstraint(String desiredChecksum, String type) {
        if (StringUtils.isEmpty((String)type)) {
            this.whereClause = "this.checksumSHA1 == desiredChecksum || this.checksumMD5 == desiredChecksum";
        } else if (!type.equals(SHA1) && !type.equals(MD5)) {
            this.whereClause = "this.checksumSHA1 == desiredChecksum || this.checksumMD5 == desiredChecksum";
        } else if (type.equals(SHA1) || type.equals(MD5)) {
            this.whereClause = "this.checksum" + type.trim() + " == desiredChecksum";
        }
        this.declParams = new String[]{"String desiredChecksum"};
        this.params = new Object[]{desiredChecksum.toLowerCase()};
    }

    public String getSortColumn() {
        return "groupId";
    }

    public String getWhereCondition() {
        return this.whereClause;
    }
}

