/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import org.apache.maven.archiva.database.DeclarativeConstraint;
import org.apache.maven.archiva.database.constraints.AbstractDeclarativeConstraint;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.Dependency;

public class ProjectsByArtifactUsageConstraint
extends AbstractDeclarativeConstraint
implements DeclarativeConstraint {
    private String filter;

    public ProjectsByArtifactUsageConstraint(ArchivaArtifact artifact) {
        this(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
    }

    public ProjectsByArtifactUsageConstraint(String groupId, String artifactId, String version) {
        this.declImports = new String[]{"import " + Dependency.class.getName()};
        this.variables = new String[]{"Dependency dep"};
        this.declParams = new String[]{"String selectedGroupId", "String selectedArtifactId", "String selectedVersion"};
        this.filter = "dependencies.contains( dep ) && dep.groupId == selectedGroupId && dep.artifactId == selectedArtifactId && dep.version == selectedVersion";
        this.params = new Object[]{groupId, artifactId, version};
    }

    public String getSortColumn() {
        return "groupId";
    }

    public String getWhereCondition() {
        return null;
    }

    public String getFilter() {
        return this.filter;
    }
}

