/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.AbstractDeclarativeConstraint;
import org.apache.maven.archiva.model.ArchivaArtifact;

public class RepositoryProblemByArtifactConstraint
extends AbstractDeclarativeConstraint
implements Constraint {
    private String whereClause;

    private void createWhereClause(ArchivaArtifact artifact) {
        this.whereClause = "groupId.like(desiredGroupId) && artifactId.like(desiredArtifactId) && version.like(desiredVersion)";
        this.declParams = new String[]{"String desiredGroupId", "String desiredArtifactId", "String desiredVersion"};
        this.params = new Object[]{artifact.getGroupId() + "%", artifact.getArtifactId() + "%", artifact.getVersion() + "%"};
    }

    public RepositoryProblemByArtifactConstraint(ArchivaArtifact desiredArtifact) {
        this.createWhereClause(desiredArtifact);
    }

    public String getSortColumn() {
        return "artifactId";
    }

    public String getWhereCondition() {
        return this.whereClause;
    }
}

