/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlBuilder {
    public static void appendWhereSelectedRepositories(StringBuffer sql, String fieldId, List<String> selectedRepositoryIds) {
        if (fieldId == null) {
            throw new NullPointerException("Null field id is not allowed.");
        }
        if (StringUtils.isBlank((String)fieldId)) {
            throw new IllegalArgumentException("Blank field id is not allowed.");
        }
        if (selectedRepositoryIds == null) {
            throw new NullPointerException("Selected repositories cannot be null.");
        }
        if (selectedRepositoryIds.isEmpty()) {
            throw new IllegalArgumentException("Selected repositories cannot be null.");
        }
        sql.append(" (");
        boolean multiple = false;
        for (String repo : selectedRepositoryIds) {
            if (multiple) {
                sql.append(" || ");
            }
            sql.append(" ").append(fieldId).append(" == \"").append(repo).append("\"");
            multiple = true;
        }
        sql.append(" )");
    }
}

