/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import java.util.List;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.AbstractSimpleConstraint;
import org.apache.maven.archiva.database.constraints.SqlBuilder;
import org.apache.maven.archiva.model.ArchivaArtifactModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueGroupIdConstraint
extends AbstractSimpleConstraint
implements Constraint {
    private StringBuffer sql = new StringBuffer();

    public UniqueGroupIdConstraint() {
        this.appendSelect(this.sql);
        this.appendGroupBy(this.sql);
    }

    public UniqueGroupIdConstraint(List<String> selectedRepositories) {
        this.appendSelect(this.sql);
        this.sql.append(" WHERE ");
        SqlBuilder.appendWhereSelectedRepositories(this.sql, "repositoryId", selectedRepositories);
        this.appendGroupBy(this.sql);
    }

    public UniqueGroupIdConstraint(List<String> selectedRepositories, String groupIdPrefix) {
        this.appendSelect(this.sql);
        this.sql.append(" WHERE ");
        SqlBuilder.appendWhereSelectedRepositories(this.sql, "repositoryId", selectedRepositories);
        this.sql.append(" && ");
        this.appendWhereGroupIdStartsWith(this.sql);
        this.appendGroupBy(this.sql);
        this.params = new Object[]{groupIdPrefix};
    }

    public UniqueGroupIdConstraint(String groupIdPrefix) {
        this.appendSelect(this.sql);
        this.sql.append(" WHERE ");
        this.appendWhereGroupIdStartsWith(this.sql);
        this.appendGroupBy(this.sql);
        this.params = new Object[]{groupIdPrefix};
    }

    @Override
    public Class getResultClass() {
        return String.class;
    }

    @Override
    public String getSelectSql() {
        return this.sql.toString();
    }

    private void appendGroupBy(StringBuffer buf) {
        buf.append(" GROUP BY groupId ORDER BY groupId ASCENDING");
    }

    private void appendSelect(StringBuffer buf) {
        buf.append("SELECT groupId FROM ").append(ArchivaArtifactModel.class.getName());
    }

    private void appendWhereGroupIdStartsWith(StringBuffer buf) {
        buf.append(" groupId.startsWith(groupIdPrefix) PARAMETERS String groupIdPrefix");
    }
}

