/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.updater;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.maven.archiva.consumers.ArchivaArtifactConsumer;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.constraints.ArtifactsProcessedConstraint;
import org.apache.maven.archiva.database.updater.DatabaseConsumers;
import org.apache.maven.archiva.database.updater.DatabaseUpdater;
import org.apache.maven.archiva.database.updater.ProcessArchivaArtifactClosure;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.functors.UnprocessedArtifactPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdoDatabaseUpdater
implements DatabaseUpdater {
    private Logger log = LoggerFactory.getLogger(JdoDatabaseUpdater.class);
    private ArchivaDAO dao;
    private DatabaseConsumers dbConsumers;
    private ProcessArchivaArtifactClosure processArtifactClosure = new ProcessArchivaArtifactClosure();

    public void update() throws ArchivaDatabaseException {
        this.updateAllUnprocessed();
        this.updateAllProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllUnprocessed() throws ArchivaDatabaseException {
        List unprocessedArtifacts = this.dao.getArtifactDAO().queryArtifacts(new ArtifactsProcessedConstraint(false));
        this.beginConsumerLifecycle(this.dbConsumers.getSelectedUnprocessedConsumers());
        try {
            UnprocessedArtifactPredicate predicate = UnprocessedArtifactPredicate.getInstance();
            Iterator it = IteratorUtils.filteredIterator(unprocessedArtifacts.iterator(), (Predicate)predicate);
            while (it.hasNext()) {
                ArchivaArtifact artifact = (ArchivaArtifact)it.next();
                this.updateUnprocessed(artifact);
            }
        }
        finally {
            this.endConsumerLifecycle(this.dbConsumers.getSelectedUnprocessedConsumers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllProcessed() throws ArchivaDatabaseException {
        List processedArtifacts = this.dao.getArtifactDAO().queryArtifacts(new ArtifactsProcessedConstraint(true));
        this.beginConsumerLifecycle(this.dbConsumers.getSelectedCleanupConsumers());
        try {
            Predicate predicate = NotPredicate.getInstance((Predicate)UnprocessedArtifactPredicate.getInstance());
            Iterator it = IteratorUtils.filteredIterator(processedArtifacts.iterator(), (Predicate)predicate);
            while (it.hasNext()) {
                ArchivaArtifact artifact = (ArchivaArtifact)it.next();
                this.updateProcessed(artifact);
            }
        }
        finally {
            this.endConsumerLifecycle(this.dbConsumers.getSelectedCleanupConsumers());
        }
    }

    private void endConsumerLifecycle(List consumers) {
        for (ArchivaArtifactConsumer consumer : consumers) {
            consumer.completeScan();
        }
    }

    private void beginConsumerLifecycle(List consumers) {
        for (ArchivaArtifactConsumer consumer : consumers) {
            consumer.beginScan();
        }
    }

    public void updateUnprocessed(ArchivaArtifact artifact) throws ArchivaDatabaseException {
        List consumers = this.dbConsumers.getSelectedUnprocessedConsumers();
        if (CollectionUtils.isEmpty((Collection)consumers)) {
            this.log.warn("There are no selected consumers for unprocessed artifacts.");
            return;
        }
        this.processArtifactClosure.setArtifact(artifact);
        CollectionUtils.forAllDo((Collection)consumers, (Closure)this.processArtifactClosure);
        artifact.getModel().setWhenProcessed(new Date());
        this.dao.getArtifactDAO().saveArtifact(artifact);
    }

    public void updateProcessed(ArchivaArtifact artifact) throws ArchivaDatabaseException {
        List consumers = this.dbConsumers.getSelectedCleanupConsumers();
        if (CollectionUtils.isEmpty((Collection)consumers)) {
            this.log.warn("There are no selected consumers for artifact cleanup.");
            return;
        }
        this.processArtifactClosure.setArtifact(artifact);
        CollectionUtils.forAllDo((Collection)consumers, (Closure)this.processArtifactClosure);
    }
}

