/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.updater;

import org.apache.commons.collections.Closure;
import org.apache.maven.archiva.consumers.ArchivaArtifactConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessArchivaArtifactClosure
implements Closure {
    private Logger log = LoggerFactory.getLogger(ProcessArchivaArtifactClosure.class);
    private ArchivaArtifact artifact;

    ProcessArchivaArtifactClosure() {
    }

    public void execute(Object input) {
        if (input instanceof ArchivaArtifactConsumer) {
            ArchivaArtifactConsumer consumer = (ArchivaArtifactConsumer)input;
            try {
                consumer.processArchivaArtifact(this.artifact);
            }
            catch (ConsumerException e) {
                this.log.warn("Unable to process artifact [" + this.artifact + "] with consumer [" + consumer.getId() + "]", (Throwable)e);
            }
        }
    }

    public ArchivaArtifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ArchivaArtifact artifact) {
        this.artifact = artifact;
    }
}

