/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.browsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.common.utils.VersionUtil;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.database.browsing.BrowsingResults;
import org.apache.maven.archiva.database.browsing.GroupIdFilter;
import org.apache.maven.archiva.database.browsing.RepositoryBrowsing;
import org.apache.maven.archiva.database.constraints.ArtifactsRelatedConstraint;
import org.apache.maven.archiva.database.constraints.ProjectsByArtifactUsageConstraint;
import org.apache.maven.archiva.database.constraints.UniqueArtifactIdConstraint;
import org.apache.maven.archiva.database.constraints.UniqueGroupIdConstraint;
import org.apache.maven.archiva.database.constraints.UniqueVersionConstraint;
import org.apache.maven.archiva.database.updater.DatabaseUpdater;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.Keys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryBrowsing
implements RepositoryBrowsing {
    private Logger log = LoggerFactory.getLogger(DefaultRepositoryBrowsing.class);
    private ArchivaDAO dao;
    private DatabaseUpdater dbUpdater;

    @Override
    public BrowsingResults getRoot(String principal, List<String> observableRepositoryIds) {
        BrowsingResults results = new BrowsingResults();
        if (!observableRepositoryIds.isEmpty()) {
            List<String> groups = this.dao.query(new UniqueGroupIdConstraint(observableRepositoryIds));
            results.setSelectedRepositoryIds(observableRepositoryIds);
            results.setGroupIds(GroupIdFilter.filterGroups(groups));
        }
        return results;
    }

    @Override
    public BrowsingResults selectArtifactId(String principal, List<String> observableRepositoryIds, String groupId, String artifactId) {
        BrowsingResults results = new BrowsingResults(groupId, artifactId);
        if (!observableRepositoryIds.isEmpty()) {
            List<String> versions = this.dao.query(new UniqueVersionConstraint(observableRepositoryIds, groupId, artifactId));
            results.setSelectedRepositoryIds(observableRepositoryIds);
            results.setVersions(this.processSnapshots(versions));
        }
        return results;
    }

    @Override
    public BrowsingResults selectGroupId(String principal, List<String> observableRepositoryIds, String groupId) {
        BrowsingResults results = new BrowsingResults(groupId);
        if (!observableRepositoryIds.isEmpty()) {
            List<String> groups = this.dao.query(new UniqueGroupIdConstraint(observableRepositoryIds, groupId));
            List<String> artifacts = this.dao.query(new UniqueArtifactIdConstraint(observableRepositoryIds, groupId));
            CollectionUtils.filter(groups, (Predicate)NotPredicate.getInstance((Predicate)PredicateUtils.equalPredicate((Object)groupId)));
            results.setSelectedRepositoryIds(observableRepositoryIds);
            results.setGroupIds(groups);
            results.setArtifacts(artifacts);
        }
        return results;
    }

    @Override
    public ArchivaProjectModel selectVersion(String principal, List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaProjectModel model;
        if (observableRepositoryIds.isEmpty()) {
            throw new ArchivaDatabaseException("There are no observable repositories for the user " + principal);
        }
        ArchivaArtifact pomArtifact = this.getArtifact(principal, observableRepositoryIds, groupId, artifactId, version);
        if (!pomArtifact.getModel().isProcessed()) {
            this.dbUpdater.updateUnprocessed(pomArtifact);
        }
        if ((model = this.getProjectModel(groupId, artifactId, pomArtifact.getVersion())).getPackaging() == null || "".equals(model.getPackaging())) {
            model.setPackaging(pomArtifact.getType());
        }
        return model;
    }

    @Override
    public String getRepositoryId(String principal, List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        if (observableRepositoryIds.isEmpty()) {
            throw new ArchivaDatabaseException("There are no observable repositories for the user " + principal);
        }
        try {
            ArchivaArtifact pomArchivaArtifact = this.getArtifact(principal, observableRepositoryIds, groupId, artifactId, version);
            return pomArchivaArtifact.getModel().getRepositoryId();
        }
        catch (ObjectNotFoundException e) {
            return this.getNoPomArtifactRepoId(principal, observableRepositoryIds, groupId, artifactId, version, observableRepositoryIds.get(0));
        }
    }

    @Override
    public List<String> getOtherSnapshotVersions(List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArrayList<String> timestampedVersions = new ArrayList<String>();
        if (VersionUtil.isSnapshot((String)version)) {
            List<?> versions = this.dao.query(new UniqueVersionConstraint(observableRepositoryIds, groupId, artifactId));
            for (String uniqueVersion : versions) {
                if (!VersionUtil.getBaseVersion((String)uniqueVersion).equals(version) && !VersionUtil.getBaseVersion((String)uniqueVersion).equals(VersionUtil.getBaseVersion((String)version)) || timestampedVersions.contains(uniqueVersion)) continue;
                timestampedVersions.add(uniqueVersion);
            }
        }
        return timestampedVersions;
    }

    private ArchivaArtifact getArtifact(String principal, List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaArtifact pomArtifact;
        block6: {
            pomArtifact = null;
            ArtifactsRelatedConstraint constraint = new ArtifactsRelatedConstraint(groupId, artifactId, version);
            try {
                List<ArchivaArtifact> artifacts = this.dao.getArtifactDAO().queryArtifacts(constraint);
                if (artifacts.isEmpty()) break block6;
                for (ArchivaArtifact artifact : artifacts) {
                    if (!observableRepositoryIds.contains(artifact.getRepositoryId())) continue;
                    pomArtifact = artifact;
                    break;
                }
            }
            catch (ArchivaDatabaseException e) {
                this.log.warn("ArchivaDatabaseException occurred while querying for artifact '" + groupId + ":" + artifactId + ":" + version + "'.");
            }
        }
        if (pomArtifact == null) {
            String repositoryId;
            Iterator<String> i$ = observableRepositoryIds.iterator();
            while (i$.hasNext() && (pomArtifact = this.handleGenericSnapshots(groupId, artifactId, version, repositoryId = i$.next())) == null) {
            }
        }
        if (pomArtifact == null) {
            throw new ObjectNotFoundException("Unable to find artifact " + Keys.toKey((String)groupId, (String)artifactId, (String)version) + " in observable repository [" + StringUtils.join(observableRepositoryIds.iterator(), (String)", ") + "] for user " + principal);
        }
        return pomArtifact;
    }

    @Override
    public List<ArchivaProjectModel> getUsedBy(String principal, List<String> observableRepositoryIds, String groupId, String artifactId, String version) throws ArchivaDatabaseException {
        ProjectsByArtifactUsageConstraint constraint = new ProjectsByArtifactUsageConstraint(groupId, artifactId, version);
        List<ArchivaProjectModel> results = this.dao.getProjectModelDAO().queryProjectModels(constraint);
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    private List<String> processSnapshots(List<String> versions) {
        ArrayList<String> cleansedVersions = new ArrayList<String>();
        for (String version : versions) {
            if (VersionUtil.isSnapshot((String)version)) {
                String baseVersion = VersionUtil.getBaseVersion((String)version);
                if (cleansedVersions.contains(baseVersion)) continue;
                cleansedVersions.add(baseVersion);
                continue;
            }
            cleansedVersions.add(version);
        }
        return cleansedVersions;
    }

    private ArchivaArtifact handleGenericSnapshots(String groupId, String artifactId, String version, String repositoryId) throws ArchivaDatabaseException {
        ArchivaArtifact result = null;
        if (VersionUtil.isGenericSnapshot((String)version)) {
            List<?> versions = this.dao.query(new UniqueVersionConstraint(groupId, artifactId));
            Collections.sort(versions);
            for (String uniqueVersion : versions) {
                if (!VersionUtil.getBaseVersion((String)uniqueVersion).equals(version)) continue;
                try {
                    this.log.debug("Retrieving artifact with version " + uniqueVersion);
                    ArtifactsRelatedConstraint constraint = new ArtifactsRelatedConstraint(groupId, artifactId, uniqueVersion);
                    List<ArchivaArtifact> artifacts = this.dao.getArtifactDAO().queryArtifacts(constraint);
                    for (ArchivaArtifact artifact : artifacts) {
                        if (!artifact.getRepositoryId().equals(repositoryId)) continue;
                        result = artifact;
                    }
                }
                catch (ObjectNotFoundException e) {
                    this.log.debug("Artifact '" + groupId + ":" + artifactId + ":" + uniqueVersion + "' in repository '" + repositoryId + "' not found in the database.");
                }
            }
        }
        return result;
    }

    private ArchivaProjectModel getProjectModel(String groupId, String artifactId, String version) throws ArchivaDatabaseException {
        ArchivaProjectModel model = null;
        try {
            model = this.dao.getProjectModelDAO().getProjectModel(groupId, artifactId, version);
        }
        catch (ObjectNotFoundException e) {
            this.log.debug("Unable to find project model for [" + Keys.toKey((String)groupId, (String)artifactId, (String)version) + "]", (Throwable)e);
        }
        if (model == null) {
            model = new ArchivaProjectModel();
            model.setGroupId(groupId);
            model.setArtifactId(artifactId);
            model.setVersion(version);
        }
        return model;
    }

    private String getNoPomArtifactRepoId(String principal, List<String> observableRepos, String groupId, String artifactId, String version, String repositoryId) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaArtifact artifact = null;
        String type = this.getArtifactType(groupId, artifactId, version);
        artifact = this.dao.getArtifactDAO().createArtifact(groupId, artifactId, version, null, type, repositoryId);
        if (artifact == null) {
            artifact = new ArchivaArtifact(groupId, artifactId, version, null, type, repositoryId);
        }
        if (!observableRepos.contains(artifact.getModel().getRepositoryId())) {
            throw new ObjectNotFoundException("Unable to find artifact " + Keys.toKey((String)groupId, (String)artifactId, (String)version) + " in observable repository [" + StringUtils.join(observableRepos.iterator(), (String)", ") + "] for user " + principal);
        }
        return artifact.getModel().getRepositoryId();
    }

    private String getArtifactType(String groupId, String artifactId, String version) throws ObjectNotFoundException, ArchivaDatabaseException {
        String type = "jar";
        try {
            List<ArchivaArtifact> artifacts = this.dao.getArtifactDAO().queryArtifacts(new ArtifactsRelatedConstraint(groupId, artifactId, version));
            if (artifacts.size() > 0) {
                type = artifacts.get(0).getType();
            }
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        return type;
    }
}

