/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import java.util.ArrayList;
import java.util.Date;
import org.apache.maven.archiva.database.constraints.RangeConstraint;

public class ArchivaAuditLogsConstraint
extends RangeConstraint {
    private String whereClause;

    private void createWhereClause(String desiredArtifact, String desiredRepositoryId, String desiredEvent, Date startDate, Date endDate) {
        this.whereClause = "eventDate >= desiredStartDate && eventDate <= desiredEndDate";
        this.declImports = new String[]{"import java.util.Date"};
        ArrayList<String> declParamsList = new ArrayList<String>();
        declParamsList.add("Date desiredStartDate");
        declParamsList.add("Date desiredEndDate");
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(startDate);
        paramsList.add(endDate);
        if (desiredArtifact != null && !"".equals(desiredArtifact)) {
            this.whereClause = this.whereClause + " && artifact.like(desiredArtifact)";
            declParamsList.add("String desiredArtifact");
            paramsList.add(desiredArtifact);
        }
        if (desiredRepositoryId != null && !"".equals(desiredRepositoryId)) {
            this.whereClause = this.whereClause + " && repositoryId == desiredRepositoryId";
            declParamsList.add("String desiredRepositoryId");
            paramsList.add(desiredRepositoryId);
        }
        if (desiredEvent != null && !"".equals(desiredEvent)) {
            this.whereClause = this.whereClause + " && event ==  desiredEvent";
            declParamsList.add("String desiredEvent");
            paramsList.add(desiredEvent);
        }
        int size = declParamsList.size();
        this.declParams = new String[size];
        for (int i = 0; i < size; ++i) {
            this.declParams[i] = (String)declParamsList.get(i);
        }
        this.params = paramsList.toArray();
    }

    public ArchivaAuditLogsConstraint(int[] range, String desiredArtifact, String desiredRepositoryId, String desiredEvent, Date startDate, Date endDate) {
        super(range);
        this.createWhereClause(desiredArtifact, desiredRepositoryId, desiredEvent, startDate, endDate);
    }

    public ArchivaAuditLogsConstraint(String desiredArtifact, String desiredRepositoryId, String desiredEvent, Date startDate, Date endDate) {
        this.createWhereClause(desiredArtifact, desiredRepositoryId, desiredEvent, startDate, endDate);
    }

    public String getSortColumn() {
        return "eventDate";
    }

    public String getWhereCondition() {
        return this.whereClause;
    }
}

