/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import java.util.Calendar;
import java.util.Date;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.AbstractDeclarativeConstraint;

public class OlderArtifactsByAgeConstraint
extends AbstractDeclarativeConstraint
implements Constraint {
    private String whereClause;

    public OlderArtifactsByAgeConstraint(int daysOld) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1 * daysOld);
        Date cutoffDate = cal.getTime();
        this.whereClause = "this.lastModified <= cutoffDate";
        this.declImports = new String[]{"import java.util.Date"};
        this.declParams = new String[]{"java.util.Date cutoffDate"};
        this.params = new Object[]{cutoffDate};
    }

    public String getSortColumn() {
        return "groupId";
    }

    public String getWhereCondition() {
        return this.whereClause;
    }
}

