/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import java.util.List;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.AbstractSimpleConstraint;
import org.apache.maven.archiva.database.constraints.SqlBuilder;
import org.apache.maven.archiva.model.ArchivaArtifactModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueArtifactIdConstraint
extends AbstractSimpleConstraint
implements Constraint {
    private StringBuffer sql = new StringBuffer();
    private StringBuffer countSql = new StringBuffer();
    private Class<?> resultClass;

    public UniqueArtifactIdConstraint(List<String> selectedRepositoryIds, String groupId) {
        this.appendSelect(this.sql, false);
        this.sql.append(" WHERE ");
        SqlBuilder.appendWhereSelectedRepositories(this.sql, "repositoryId", selectedRepositoryIds);
        this.sql.append(" && ");
        this.appendWhereSelectedGroupId(this.sql);
        this.appendGroupBy(this.sql);
        this.countSql.append("SELECT count(artifactId) FROM ").append(ArchivaArtifactModel.class.getName());
        this.countSql.append(" WHERE ");
        SqlBuilder.appendWhereSelectedRepositories(this.countSql, "repositoryId", selectedRepositoryIds);
        this.countSql.append(" && ");
        this.appendWhereSelectedGroupId(this.countSql);
        this.appendGroupBy(this.countSql);
        this.params = new Object[]{groupId};
    }

    public UniqueArtifactIdConstraint(String groupId) {
        this.appendSelect(this.sql, false);
        this.sql.append(" WHERE ");
        this.appendWhereSelectedGroupId(this.sql);
        this.appendGroupBy(this.sql);
        this.countSql.append("SELECT count(artifactId) FROM ").append(ArchivaArtifactModel.class.getName());
        this.countSql.append(" WHERE ");
        this.appendWhereSelectedGroupId(this.countSql);
        this.appendGroupBy(this.countSql);
        this.params = new Object[]{groupId};
    }

    public UniqueArtifactIdConstraint(String repoId, boolean isUnique) {
        this.appendSelect(this.sql, isUnique);
        this.sql.append(" WHERE repositoryId == \"" + repoId + "\"");
        if (isUnique) {
            this.countSql.append("SELECT count(this) FROM ").append(ArchivaArtifactModel.class.getName());
            this.countSql.append(" WHERE repositoryId == \"").append(repoId).append("\"");
            this.countSql.append(" GROUP BY groupId, artifactId");
        } else {
            this.countSql.append("SELECT count(artifactId) FROM ").append(ArchivaArtifactModel.class.getName());
            this.countSql.append(" WHERE repositoryId == \"").append(repoId).append("\"");
        }
        this.resultClass = Object[].class;
    }

    public Class getResultClass() {
        if (this.resultClass != null) {
            return this.resultClass;
        }
        return String.class;
    }

    @Override
    public String getSelectSql() {
        return this.sql.toString();
    }

    @Override
    public String getCountSql() {
        return this.countSql.toString();
    }

    private void appendGroupBy(StringBuffer buf) {
        buf.append(" GROUP BY artifactId ORDER BY artifactId ASCENDING");
    }

    private void appendSelect(StringBuffer buf, boolean isUnique) {
        if (isUnique) {
            buf.append("SELECT DISTINCT groupId, artifactId FROM ").append(ArchivaArtifactModel.class.getName());
        } else {
            buf.append("SELECT artifactId FROM ").append(ArchivaArtifactModel.class.getName());
        }
    }

    private void appendWhereSelectedGroupId(StringBuffer buf) {
        buf.append(" groupId == selectedGroupId PARAMETERS String selectedGroupId");
    }
}

