/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.jdo;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ArtifactDAO;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.DeclarativeConstraint;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.database.jdo.JdoAccess;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.ArchivaArtifactModel;
import org.apache.maven.archiva.model.jpox.ArchivaArtifactModelKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdoArtifactDAO
implements ArtifactDAO {
    private JdoAccess jdo;

    @Override
    public ArchivaArtifact createArtifact(String groupId, String artifactId, String version, String classifier, String type, String repositoryId) {
        ArchivaArtifact artifact;
        try {
            artifact = this.getArtifact(groupId, artifactId, version, classifier, type, repositoryId);
        }
        catch (ArchivaDatabaseException e) {
            artifact = new ArchivaArtifact(groupId, artifactId, version, classifier, type, repositoryId);
        }
        return artifact;
    }

    @Override
    public ArchivaArtifact getArtifact(String groupId, String artifactId, String version, String classifier, String type, String repositoryId) throws ObjectNotFoundException, ArchivaDatabaseException {
        ArchivaArtifactModelKey key = new ArchivaArtifactModelKey();
        key.setGroupId(groupId);
        key.setArtifactId(artifactId);
        key.setVersion(version);
        key.setClassifier(classifier);
        key.setType(type);
        key.setRepositoryId(repositoryId);
        ArchivaArtifactModel model = (ArchivaArtifactModel)this.jdo.getObjectById(ArchivaArtifactModel.class, key, null);
        return new ArchivaArtifact(model);
    }

    @Override
    public List<ArchivaArtifact> queryArtifacts(Constraint constraint) throws ObjectNotFoundException, ArchivaDatabaseException {
        List<?> results = this.jdo.queryObjects(ArchivaArtifactModel.class, constraint);
        ArrayList<ArchivaArtifact> ret = null;
        if (results != null) {
            ret = new ArrayList<ArchivaArtifact>();
            for (ArchivaArtifactModel model : results) {
                ret.add(new ArchivaArtifact(model));
            }
        }
        return ret;
    }

    @Override
    public ArchivaArtifact saveArtifact(ArchivaArtifact artifact) throws ArchivaDatabaseException {
        ArchivaArtifactModel model = (ArchivaArtifactModel)this.jdo.saveObject(artifact.getModel());
        if (model == null) {
            return null;
        }
        return new ArchivaArtifact(model);
    }

    @Override
    public void deleteArtifact(ArchivaArtifact artifact) throws ArchivaDatabaseException {
        this.jdo.removeObject(artifact.getModel());
    }

    @Override
    public long countArtifacts(DeclarativeConstraint constraint) {
        return this.jdo.countObjects(ArchivaArtifactModel.class, constraint);
    }
}

