/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.project;

import java.util.List;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.model.ArchivaModelCloner;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.VersionedReference;
import org.apache.maven.archiva.repository.project.ProjectModelException;
import org.apache.maven.archiva.repository.project.ProjectModelResolver;
import org.apache.maven.archiva.repository.project.resolvers.FilesystemBasedResolver;
import org.apache.maven.archiva.repository.project.resolvers.ProjectModelResolutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectModelToDatabaseListener
implements ProjectModelResolutionListener {
    private Logger log = LoggerFactory.getLogger(ProjectModelToDatabaseListener.class);
    private ArchivaDAO dao;

    private void saveInDatabase(ArchivaProjectModel model) throws ProjectModelException {
        try {
            this.dao.getProjectModelDAO().saveProjectModel(model);
        }
        catch (ArchivaDatabaseException e) {
            throw new ProjectModelException("Unable to save model to database: " + e.getMessage(), (Throwable)e);
        }
    }

    private void removeFromDatabase(ArchivaProjectModel model) throws ProjectModelException {
        try {
            this.dao.getProjectModelDAO().deleteProjectModel(model);
        }
        catch (ArchivaDatabaseException e) {
            throw new ProjectModelException("Unable to remove existing model from database: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean existsInDatabase(ArchivaProjectModel model) throws ProjectModelException {
        try {
            ArchivaProjectModel dbmodel = this.dao.getProjectModelDAO().getProjectModel(model.getGroupId(), model.getArtifactId(), model.getVersion());
            return dbmodel != null;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (ArchivaDatabaseException e) {
            throw new ProjectModelException("Unable to check for existing model from database: " + e.getMessage(), (Throwable)e);
        }
    }

    public void resolutionAttempting(VersionedReference projectRef, ProjectModelResolver resolver) {
    }

    public void resolutionError(VersionedReference projectRef, ProjectModelResolver resolver, Exception cause) {
    }

    public void resolutionMiss(VersionedReference projectRef, ProjectModelResolver resolver) {
    }

    public void resolutionNotFound(VersionedReference projectRef, List<ProjectModelResolver> resolverList) {
    }

    public void resolutionStart(VersionedReference projectRef, List<ProjectModelResolver> resolverList) {
    }

    public void resolutionSuccess(VersionedReference projectRef, ProjectModelResolver resolver, ArchivaProjectModel model) {
        if (!(resolver instanceof FilesystemBasedResolver)) {
            return;
        }
        model = ArchivaModelCloner.clone((ArchivaProjectModel)model);
        try {
            if (this.existsInDatabase(model)) {
                this.removeFromDatabase(model);
            }
            this.saveInDatabase(model);
        }
        catch (ProjectModelException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
    }
}

