/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.updater;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.OrPredicate;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.DatabaseScanningConfiguration;
import org.apache.maven.archiva.consumers.functors.PermanentConsumerPredicate;
import org.apache.maven.archiva.database.updater.ArchivaArtifactConsumer;
import org.apache.maven.archiva.database.updater.DatabaseCleanupConsumer;
import org.apache.maven.archiva.database.updater.DatabaseUnprocessedArtifactConsumer;
import org.apache.maven.archiva.database.updater.ProcessArchivaArtifactClosure;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConsumers
implements ApplicationContextAware {
    private Logger log = LoggerFactory.getLogger(DatabaseConsumers.class);
    private ArchivaConfiguration archivaConfiguration;
    private Predicate selectedCleanupConsumers;
    private Predicate selectedUnprocessedConsumers;
    private ApplicationContext applicationContext;

    public DatabaseConsumers(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
        PermanentConsumerPredicate permanentConsumers = new PermanentConsumerPredicate();
        this.selectedCleanupConsumers = new OrPredicate((Predicate)permanentConsumers, (Predicate)new SelectedCleanupConsumersPredicate());
        this.selectedUnprocessedConsumers = new OrPredicate((Predicate)permanentConsumers, (Predicate)new SelectedUnprocessedConsumersPredicate());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public List<ArchivaArtifactConsumer> getSelectedUnprocessedConsumers() {
        ArrayList<ArchivaArtifactConsumer> ret = new ArrayList<ArchivaArtifactConsumer>();
        ret.addAll(CollectionUtils.select(this.getAvailableUnprocessedConsumers(), (Predicate)this.selectedUnprocessedConsumers));
        return ret;
    }

    public List<ArchivaArtifactConsumer> getSelectedCleanupConsumers() {
        ArrayList<ArchivaArtifactConsumer> ret = new ArrayList<ArchivaArtifactConsumer>();
        ret.addAll(CollectionUtils.select(this.getAvailableCleanupConsumers(), (Predicate)this.selectedCleanupConsumers));
        return ret;
    }

    public List<DatabaseUnprocessedArtifactConsumer> getAvailableUnprocessedConsumers() {
        return new ArrayList<DatabaseUnprocessedArtifactConsumer>(this.applicationContext.getBeansOfType(DatabaseUnprocessedArtifactConsumer.class).values());
    }

    public List<DatabaseCleanupConsumer> getAvailableCleanupConsumers() {
        return new ArrayList<DatabaseCleanupConsumer>(this.applicationContext.getBeansOfType(DatabaseCleanupConsumer.class).values());
    }

    public void executeCleanupConsumer(ArchivaArtifact artifact) {
        List<ArchivaArtifactConsumer> consumers = this.getSelectedCleanupConsumers();
        for (ArchivaArtifactConsumer consumer : consumers) {
            consumer.beginScan();
        }
        if (CollectionUtils.isEmpty(consumers)) {
            this.log.warn("There are no selected consumers for artifact cleanup.");
            return;
        }
        ProcessArchivaArtifactClosure processArtifactClosure = new ProcessArchivaArtifactClosure();
        processArtifactClosure.setArtifact(artifact);
        CollectionUtils.forAllDo(consumers, (Closure)processArtifactClosure);
        for (ArchivaArtifactConsumer consumer : consumers) {
            consumer.completeScan();
        }
    }

    class SelectedCleanupConsumersPredicate
    implements Predicate {
        SelectedCleanupConsumersPredicate() {
        }

        public boolean evaluate(Object object) {
            boolean satisfies = false;
            if (object instanceof DatabaseCleanupConsumer) {
                DatabaseCleanupConsumer consumer = (DatabaseCleanupConsumer)object;
                DatabaseScanningConfiguration config = DatabaseConsumers.this.archivaConfiguration.getConfiguration().getDatabaseScanning();
                return config.getCleanupConsumers().contains(consumer.getId());
            }
            return satisfies;
        }
    }

    class SelectedUnprocessedConsumersPredicate
    implements Predicate {
        SelectedUnprocessedConsumersPredicate() {
        }

        public boolean evaluate(Object object) {
            boolean satisfies = false;
            if (object instanceof DatabaseUnprocessedArtifactConsumer) {
                DatabaseUnprocessedArtifactConsumer consumer = (DatabaseUnprocessedArtifactConsumer)object;
                DatabaseScanningConfiguration config = DatabaseConsumers.this.archivaConfiguration.getConfiguration().getDatabaseScanning();
                return config.getUnprocessedConsumers().contains(consumer.getId());
            }
            return satisfies;
        }
    }
}

