/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.AbstractDeclarativeConstraint;

public class ArtifactVersionsConstraint
extends AbstractDeclarativeConstraint
implements Constraint {
    private String whereClause = "";
    private String sortColumn = "repositoryId";

    public ArtifactVersionsConstraint(String repoId, String groupId, String artifactId, boolean includeWhenGathered) {
        if (repoId != null) {
            this.whereClause = "repositoryId.equals(selectedRepoId) && groupId.equals(selectedGroupId) && artifactId.equals(selectedArtifactId) " + (includeWhenGathered ? "&& whenGathered != null" : "");
            this.declParams = new String[]{"String selectedRepoId", "String selectedGroupId", "String selectedArtifactId"};
            this.params = new Object[]{repoId, groupId, artifactId};
        } else {
            this.whereClause = "groupId.equals(selectedGroupId) && artifactId.equals(selectedArtifactId) " + (includeWhenGathered ? "&& whenGathered != null" : "");
            this.declParams = new String[]{"String selectedGroupId", "String selectedArtifactId"};
            this.params = new Object[]{groupId, artifactId};
        }
    }

    public ArtifactVersionsConstraint(String repoId, String groupId, String artifactId, String sortColumn) {
        this(repoId, groupId, artifactId, true);
        this.sortColumn = sortColumn;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public String getWhereCondition() {
        return this.whereClause;
    }
}

