/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.database.constraints;

import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.RangeConstraint;

public class RepositoryProblemByGroupIdConstraint
extends RangeConstraint
implements Constraint {
    private String whereClause;

    private void createWhereClause(String desiredGroupId) {
        this.whereClause = "groupId.like(desiredGroupId)";
        this.declParams = new String[]{"String desiredGroupId"};
        this.params = new Object[]{desiredGroupId + "%"};
    }

    public RepositoryProblemByGroupIdConstraint(String desiredGroupId) {
        this.createWhereClause(desiredGroupId);
    }

    public RepositoryProblemByGroupIdConstraint(int[] range, String desiredGroupId) {
        super(range);
        this.createWhereClause(desiredGroupId);
    }

    public String getSortColumn() {
        return "repositoryId";
    }

    public String getWhereCondition() {
        return this.whereClause;
    }
}

