/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.Stack;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.DependencyGraphKeys;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.walk.BaseVisitor;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphVisitor;
import org.apache.maven.archiva.model.ArtifactReference;

public class FlagExcludedEdgesVisitor
extends BaseVisitor
implements DependencyGraphVisitor {
    private Stack nodePath = new Stack();

    public void discoverEdge(DependencyGraphEdge edge) {
        ArtifactReference artifact = edge.getNodeTo();
        String toKey = DependencyGraphKeys.toManagementKey(artifact);
        for (DependencyGraphNode pathNode : this.nodePath) {
            if (!pathNode.getExcludes().contains(toKey)) continue;
            edge.setDisabled(true);
            edge.setDisabledType(1);
            String whoExcluded = DependencyGraphKeys.toKey(pathNode);
            edge.setDisabledReason("Specifically Excluded by " + whoExcluded);
            break;
        }
    }

    public void discoverNode(DependencyGraphNode node) {
        super.discoverNode(node);
        this.nodePath.push(node);
    }

    public void finishNode(DependencyGraphNode node) {
        super.finishNode(node);
        DependencyGraphNode pathNode = (DependencyGraphNode)this.nodePath.pop();
        if (!node.equals(pathNode)) {
            String pathNodeKey = ArtifactReference.toKey((ArtifactReference)pathNode.getArtifact());
            String finishNodeKey = ArtifactReference.toKey((ArtifactReference)node.getArtifact());
            throw new IllegalStateException("Encountered bad visitor state.  Expected finish on node " + pathNodeKey + ", but instead got notified of node " + finishNodeKey);
        }
    }
}

