/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.archiva.dependency.graph.GraphListener;
import org.apache.maven.archiva.dependency.graph.GraphPhaseEvent;
import org.apache.maven.archiva.dependency.graph.GraphTask;
import org.apache.maven.archiva.dependency.graph.GraphTaskException;
import org.apache.maven.archiva.dependency.graph.PotentialCyclicEdgeProducer;
import org.apache.maven.archiva.dependency.graph.tasks.FlagCyclicEdgesTask;
import org.apache.maven.archiva.dependency.graph.tasks.FlagExcludedEdgesTask;
import org.apache.maven.archiva.dependency.graph.tasks.PopulateGraphMasterTask;
import org.apache.maven.archiva.dependency.graph.tasks.ReduceEnabledEdgesTask;
import org.apache.maven.archiva.dependency.graph.tasks.ReduceScopeTask;
import org.apache.maven.archiva.dependency.graph.tasks.ReduceTransitiveEdgesTask;
import org.apache.maven.archiva.dependency.graph.tasks.RefineConflictsTask;
import org.apache.maven.archiva.dependency.graph.tasks.UpdateScopesTask;
import org.apache.maven.archiva.model.VersionedReference;

public class DependencyGraphFactory {
    private GraphTask taskFlagCyclicEdges;
    private PopulateGraphMasterTask taskPopulateGraph;
    private ReduceScopeTask taskReduceScope;
    private List listeners = new ArrayList();
    private DependencyGraphBuilder graphBuilder;
    private List tasks;

    public DependencyGraphFactory() {
        this.taskFlagCyclicEdges = new FlagCyclicEdgesTask();
        this.taskPopulateGraph = new PopulateGraphMasterTask();
        this.taskReduceScope = new ReduceScopeTask("test");
        this.tasks = new ArrayList();
        this.tasks.add(this.taskPopulateGraph);
        this.tasks.add(new FlagExcludedEdgesTask());
        this.tasks.add(new ReduceEnabledEdgesTask());
        this.tasks.add(new RefineConflictsTask());
        this.tasks.add(this.taskReduceScope);
        this.tasks.add(new ReduceTransitiveEdgesTask());
        this.tasks.add(new UpdateScopesTask());
    }

    public void addGraphListener(GraphListener listener) {
        this.listeners.add(listener);
    }

    public DependencyGraph getGraph(VersionedReference versionedProjectReference) throws GraphTaskException {
        DependencyGraph graph = this.graphBuilder.createGraph(versionedProjectReference);
        this.triggerGraphPhase(0, null, graph);
        for (GraphTask task : this.tasks) {
            try {
                this.triggerGraphPhase(1, task, graph);
                task.executeTask(graph);
                if (task instanceof PotentialCyclicEdgeProducer) {
                    this.taskFlagCyclicEdges.executeTask(graph);
                }
                this.triggerGraphPhase(2, task, graph);
            }
            catch (GraphTaskException e) {
                this.triggerGraphError(e, graph);
                throw e;
            }
            catch (Exception e) {
                GraphTaskException gte = new GraphTaskException(e.getMessage(), e);
                this.triggerGraphError(gte, graph);
                throw gte;
            }
        }
        this.triggerGraphPhase(10, null, graph);
        return graph;
    }

    public void removeGraphListener(GraphListener listener) {
        this.listeners.remove(listener);
    }

    public void setDesiredScope(String scope) {
        this.taskReduceScope.setScope(scope);
    }

    public void setGraphBuilder(DependencyGraphBuilder graphBuilder) {
        this.graphBuilder = graphBuilder;
        this.taskPopulateGraph.setBuilder(graphBuilder);
    }

    private void triggerGraphError(GraphTaskException e, DependencyGraph graph) {
        for (GraphListener listener : this.listeners) {
            listener.graphError(e, graph);
        }
    }

    private void triggerGraphPhase(int type, GraphTask task, DependencyGraph graph) {
        GraphPhaseEvent evt = new GraphPhaseEvent(type, task, graph);
        for (GraphListener listener : this.listeners) {
            listener.graphPhaseEvent(evt);
        }
    }
}

