/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph;

import org.apache.maven.archiva.dependency.graph.DependencyGraphKeys;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.model.ArtifactReference;

public class DependencyGraphEdge {
    private ArtifactReference nodeFrom;
    private ArtifactReference nodeTo;
    private String scope;
    private boolean disabled = false;
    private int disabledType;
    private String disabledReason;

    public DependencyGraphEdge(ArtifactReference fromNode, ArtifactReference toNode) {
        this.nodeFrom = fromNode;
        this.nodeTo = toNode;
        this.scope = "compile";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyGraphEdge other = (DependencyGraphEdge)obj;
        if (this.nodeFrom == null ? other.nodeFrom != null : !this.nodeFrom.equals((Object)other.nodeFrom)) {
            return false;
        }
        return !(this.nodeTo == null ? other.nodeTo != null : !this.nodeTo.equals((Object)other.nodeTo));
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public int getDisabledType() {
        return this.disabledType;
    }

    public ArtifactReference getNodeFrom() {
        return this.nodeFrom;
    }

    public ArtifactReference getNodeTo() {
        return this.nodeTo;
    }

    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.nodeFrom == null ? 0 : this.nodeFrom.hashCode());
        result = 31 * result + (this.nodeTo == null ? 0 : this.nodeTo.hashCode());
        return result;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (!this.disabled) {
            this.disabledReason = null;
            this.disabledType = -1;
        }
    }

    public void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    public void setDisabledType(int disabledType) {
        this.disabledType = disabledType;
    }

    public void setNodeFrom(ArtifactReference ref) {
        this.nodeFrom = ref;
    }

    public void setNodeFrom(DependencyGraphNode node) {
        this.nodeFrom = node.getArtifact();
    }

    public void setNodeTo(ArtifactReference ref) {
        this.nodeTo = ref;
    }

    public void setNodeTo(DependencyGraphNode node) {
        this.nodeTo = node.getArtifact();
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GraphEdge[");
        sb.append("from=").append(DependencyGraphKeys.toKey(this.nodeFrom));
        sb.append(",to=").append(DependencyGraphKeys.toKey(this.nodeTo));
        sb.append("]");
        return sb.toString();
    }
}

