/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph;

import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.DependencyGraphUtils;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.model.VersionedReference;
import org.apache.maven.archiva.repository.project.ProjectModelException;
import org.apache.maven.archiva.repository.project.ProjectModelResolverFactory;
import org.apache.maven.archiva.repository.project.filters.EffectiveProjectModelFilter;

public class ProjectModelBasedGraphBuilder
implements DependencyGraphBuilder {
    private ProjectModelResolverFactory resolverFactory;
    private EffectiveProjectModelFilter effectiveFilter = new EffectiveProjectModelFilter();

    public DependencyGraph createGraph(VersionedReference versionedProjectReference) {
        String groupId = versionedProjectReference.getGroupId();
        String artifactId = versionedProjectReference.getArtifactId();
        String version = versionedProjectReference.getVersion();
        DependencyGraph graph = new DependencyGraph(groupId, artifactId, version);
        return graph;
    }

    public void resolveNode(DependencyGraph graph, DependencyGraphNode fromNode, VersionedReference versionedProjectReference) {
        ArchivaProjectModel model = this.resolveModel(fromNode.getArtifact());
        DependencyGraphUtils.addNodeFromModel(model, graph, fromNode);
    }

    private ArchivaProjectModel resolveModel(ArtifactReference reference) {
        VersionedReference projectRef = new VersionedReference();
        projectRef.setGroupId(reference.getGroupId());
        projectRef.setArtifactId(reference.getArtifactId());
        projectRef.setVersion(reference.getVersion());
        ArchivaProjectModel model = this.resolverFactory.getCurrentResolverStack().findProject(projectRef);
        if (model == null) {
            return this.createDefaultModel(reference);
        }
        try {
            ArchivaProjectModel processedModel = this.effectiveFilter.filter(model);
            return processedModel;
        }
        catch (ProjectModelException e) {
            e.printStackTrace(System.err);
            return this.createDefaultModel(reference);
        }
    }

    private ArchivaProjectModel createDefaultModel(ArtifactReference reference) {
        ArchivaProjectModel model = new ArchivaProjectModel();
        model = new ArchivaProjectModel();
        model.setGroupId(reference.getGroupId());
        model.setArtifactId(reference.getArtifactId());
        model.setVersion(reference.getVersion());
        model.setPackaging(reference.getType());
        return model;
    }
}

