/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.Stack;
import org.apache.commons.collections.Predicate;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.functors.EdgeFromPredicate;
import org.apache.maven.archiva.dependency.graph.walk.BaseVisitor;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphVisitor;

public class UpdateScopesVisitor
extends BaseVisitor
implements DependencyGraphVisitor {
    private Stack<String> scopeStack = new Stack();
    private Predicate rootEdgePredicate;

    public UpdateScopesVisitor() {
        this.scopeStack.add("compile");
    }

    public void discoverGraph(DependencyGraph graph) {
        super.discoverGraph(graph);
        this.rootEdgePredicate = new EdgeFromPredicate(graph.getRootNode());
    }

    public void discoverEdge(DependencyGraphEdge edge) {
        super.discoverEdge(edge);
        String scope = edge.getScope();
        if (!this.rootEdgePredicate.evaluate((Object)edge)) {
            scope = this.scopeStack.peek();
            edge.setScope(scope);
        }
        this.scopeStack.push(scope);
    }

    public void finishEdge(DependencyGraphEdge edge) {
        super.finishEdge(edge);
        this.scopeStack.pop();
    }
}

