/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.consumers.lucene;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ConfigurationNames;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.consumers.DatabaseUnprocessedArtifactConsumer;
import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryContentIndexFactory;
import org.apache.maven.archiva.indexer.RepositoryIndexException;
import org.apache.maven.archiva.indexer.hashcodes.HashcodesRecord;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexArtifactConsumer
extends AbstractMonitoredConsumer
implements DatabaseUnprocessedArtifactConsumer,
RegistryListener,
Initializable {
    private Logger log = LoggerFactory.getLogger(IndexArtifactConsumer.class);
    private static final String INDEX_ERROR = "indexing_error";
    private String id;
    private String description;
    private ArchivaConfiguration configuration;
    private RepositoryContentFactory repositoryFactory;
    private RepositoryContentIndexFactory indexFactory;
    private Map<String, IndexedRepositoryDetails> repositoryMap = new HashMap<String, IndexedRepositoryDetails>();

    public void beginScan() {
    }

    public void completeScan() {
    }

    public List<String> getIncludedTypes() {
        return null;
    }

    public void processArchivaArtifact(ArchivaArtifact artifact) throws ConsumerException {
        HashcodesRecord record = new HashcodesRecord();
        record.setRepositoryId(artifact.getModel().getRepositoryId());
        record.setArtifact(artifact);
        IndexedRepositoryDetails pnl = this.getIndexedRepositoryDetails(artifact);
        String artifactPath = pnl.repository.toPath(artifact);
        record.setFilename(artifactPath);
        try {
            pnl.index.modifyRecord((LuceneRepositoryContentRecord)record);
        }
        catch (RepositoryIndexException e) {
            this.triggerConsumerError(INDEX_ERROR, "Unable to index hashcodes: " + e.getMessage());
        }
    }

    private IndexedRepositoryDetails getIndexedRepositoryDetails(ArchivaArtifact artifact) {
        String repoId = artifact.getModel().getRepositoryId();
        if (StringUtils.isBlank((String)repoId)) {
            throw new IllegalStateException("Unable to process artifact [" + artifact + "] as it has no repository id associated with it.");
        }
        return this.getIndexedRepositoryDetails(repoId);
    }

    private IndexedRepositoryDetails getIndexedRepositoryDetails(String id) {
        return this.repositoryMap.get(id);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPermanent() {
        return false;
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isManagedRepositories((String)propertyName)) {
            this.initRepositoryMap();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    public void initialize() throws InitializationException {
        this.initRepositoryMap();
        this.configuration.addChangeListener((RegistryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositoryMap() {
        Map<String, IndexedRepositoryDetails> map = this.repositoryMap;
        synchronized (map) {
            this.repositoryMap.clear();
            for (ManagedRepositoryConfiguration repository : this.configuration.getConfiguration().getManagedRepositories()) {
                try {
                    IndexedRepositoryDetails pnl = new IndexedRepositoryDetails();
                    pnl.repository = this.repositoryFactory.getManagedRepositoryContent(repository.getId());
                    pnl.index = this.indexFactory.createHashcodeIndex(repository);
                    this.repositoryMap.put(repository.getId(), pnl);
                }
                catch (RepositoryException e) {
                    this.log.error("Unable to load repository content object: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    class IndexedRepositoryDetails {
        public ManagedRepositoryContent repository;
        public RepositoryContentIndex index;

        IndexedRepositoryDetails() {
        }
    }
}

