/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.consumers.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.FileTypes;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryContentIndexFactory;
import org.apache.maven.archiva.indexer.RepositoryIndexException;
import org.apache.maven.archiva.indexer.filecontent.FileContentRecord;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.apache.maven.archiva.repository.layout.LayoutException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexContentConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer,
RegistryListener,
Initializable {
    private Logger log = LoggerFactory.getLogger(IndexContentConsumer.class);
    private static final String READ_CONTENT = "read_content";
    private static final String INDEX_ERROR = "indexing_error";
    private String id;
    private String description;
    private ArchivaConfiguration configuration;
    private FileTypes filetypes;
    private RepositoryContentFactory repositoryFactory;
    private RepositoryContentIndexFactory indexFactory;
    private List<String> propertyNameTriggers = new ArrayList<String>();
    private List<String> includes = new ArrayList<String>();
    private RepositoryContentIndex index;
    private ManagedRepositoryContent repository;
    private File repositoryDir;

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPermanent() {
        return false;
    }

    public List<String> getExcludes() {
        return null;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void beginScan(ManagedRepositoryConfiguration repo, Date whenGathered) throws ConsumerException {
        try {
            this.repository = this.repositoryFactory.getManagedRepositoryContent(repo.getId());
            this.repositoryDir = new File(this.repository.getRepoRoot());
            this.index = this.indexFactory.createFileContentIndex(this.repository.getRepository());
        }
        catch (RepositoryException e) {
            throw new ConsumerException("Unable to start IndexContentConsumer: " + e.getMessage(), (Throwable)e);
        }
    }

    public void processFile(String path) throws ConsumerException {
        if (path.endsWith("/maven-metadata.xml")) {
            this.log.debug("File is a metadata file. Not indexing.");
            return;
        }
        FileContentRecord record = new FileContentRecord();
        try {
            File file = new File(this.repositoryDir, path);
            record.setRepositoryId(this.repository.getId());
            record.setFilename(path);
            record.setContents(FileUtils.readFileToString((File)file, null));
            try {
                ArtifactReference ref = this.repository.toArtifactReference(path);
                ArchivaArtifact artifact = new ArchivaArtifact(ref);
                record.setArtifact(artifact);
            }
            catch (LayoutException e) {
                // empty catch block
            }
            this.index.modifyRecord((LuceneRepositoryContentRecord)record);
        }
        catch (IOException e) {
            this.triggerConsumerError(READ_CONTENT, "Unable to read file contents: " + e.getMessage());
        }
        catch (RepositoryIndexException e) {
            this.triggerConsumerError(INDEX_ERROR, "Unable to index file contents: " + e.getMessage());
        }
    }

    public void completeScan() {
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (this.propertyNameTriggers.contains(propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        this.includes.clear();
        this.includes.addAll(this.filetypes.getFileTypePatterns("indexable-content"));
    }

    public void initialize() throws InitializationException {
        this.propertyNameTriggers = new ArrayList<String>();
        this.propertyNameTriggers.add("repositoryScanning");
        this.propertyNameTriggers.add("fileTypes");
        this.propertyNameTriggers.add("fileType");
        this.propertyNameTriggers.add("patterns");
        this.propertyNameTriggers.add("pattern");
        this.configuration.addChangeListener((RegistryListener)this);
        this.initIncludes();
    }
}

