/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.consumers.lucene;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.consumers.DatabaseUnprocessedArtifactConsumer;
import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryContentIndexFactory;
import org.apache.maven.archiva.indexer.RepositoryIndexException;
import org.apache.maven.archiva.indexer.bytecode.BytecodeRecord;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexJavaPublicMethodsConsumer
extends AbstractMonitoredConsumer
implements DatabaseUnprocessedArtifactConsumer {
    private String id;
    private String description;
    private RepositoryContentIndexFactory repoIndexFactory;
    private RepositoryContentFactory repoFactory;
    private static final String CLASSES = "classes";
    private static final String METHODS = "methods";
    private List<String> includes = new ArrayList<String>();

    public IndexJavaPublicMethodsConsumer() {
        this.includes.add("jar");
        this.includes.add("war");
        this.includes.add("ear");
        this.includes.add("zip");
        this.includes.add("tar.gz");
        this.includes.add("tar.bz2");
        this.includes.add("car");
        this.includes.add("sar");
        this.includes.add("mar");
        this.includes.add("rar");
    }

    public void beginScan() {
    }

    public void completeScan() {
    }

    public List<String> getIncludedTypes() {
        return this.includes;
    }

    public void processArchivaArtifact(ArchivaArtifact artifact) throws ConsumerException {
        try {
            ManagedRepositoryContent repoContent = this.repoFactory.getManagedRepositoryContent(artifact.getModel().getRepositoryId());
            File file = new File(repoContent.getRepoRoot(), repoContent.toPath(artifact));
            if ((file.getAbsolutePath().endsWith(".jar") || file.getAbsolutePath().endsWith(".war") || file.getAbsolutePath().endsWith(".ear") || file.getAbsolutePath().endsWith(".zip") || file.getAbsolutePath().endsWith(".tar.gz") || file.getAbsolutePath().endsWith(".tar.bz2") || file.getAbsolutePath().endsWith(".car") || file.getAbsolutePath().endsWith(".sar") || file.getAbsolutePath().endsWith(".mar") || file.getAbsolutePath().endsWith(".rar")) && file.exists()) {
                List<String> files = this.readFilesInArchive(file);
                Map<String, List<String>> mapOfClassesAndMethods = this.getPublicClassesAndMethodsFromFiles(file.getAbsolutePath(), files);
                RepositoryContentIndex bytecodeIndex = this.repoIndexFactory.createBytecodeIndex(repoContent.getRepository());
                BytecodeRecord bytecodeRecord = new BytecodeRecord();
                bytecodeRecord.setFilename(file.getName());
                bytecodeRecord.setClasses(mapOfClassesAndMethods.get(CLASSES));
                bytecodeRecord.setFiles(files);
                bytecodeRecord.setMethods(mapOfClassesAndMethods.get(METHODS));
                bytecodeRecord.setArtifact(artifact);
                bytecodeRecord.setRepositoryId(artifact.getModel().getRepositoryId());
                bytecodeIndex.modifyRecord((LuceneRepositoryContentRecord)bytecodeRecord);
            }
        }
        catch (RepositoryException e) {
            throw new ConsumerException("Can't run index cleanup consumer: " + e.getMessage());
        }
        catch (RepositoryIndexException e) {
            throw new ConsumerException("Error encountered while adding artifact to index: " + e.getMessage());
        }
        catch (IOException e) {
            throw new ConsumerException("Error encountered while getting file contents: " + e.getMessage());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPermanent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFilesInArchive(File file) throws IOException {
        ArrayList<String> files;
        ZipFile zipFile = new ZipFile(file);
        try {
            files = new ArrayList<String>(zipFile.size());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                files.add(entry.getName());
            }
        }
        finally {
            this.closeQuietly(zipFile);
        }
        return files;
    }

    private void closeQuietly(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isClass(String name) {
        return name.endsWith(".class") && name.lastIndexOf("$") < 0;
    }

    private Map<String, List<String>> getPublicClassesAndMethodsFromFiles(String zipFile, List<String> files) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> methods = new ArrayList<String>();
        ArrayList<String> classes = new ArrayList<String>();
        for (String file : files) {
            if (!IndexJavaPublicMethodsConsumer.isClass(file)) continue;
            try {
                Method[] methodsArr;
                ClassParser parser = new ClassParser(zipFile, file);
                JavaClass javaClass = parser.parse();
                if (javaClass.isPublic()) {
                    classes.add(javaClass.getClassName());
                }
                for (Method method : methodsArr = javaClass.getMethods()) {
                    if (!method.isPublic()) continue;
                    methods.add(method.getName());
                }
            }
            catch (IOException e) {
            }
        }
        map.put(CLASSES, classes);
        map.put(METHODS, methods);
        return map;
    }
}

