/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.consumers.lucene;

import java.io.File;
import java.util.List;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.consumers.DatabaseCleanupConsumer;
import org.apache.maven.archiva.indexer.RepositoryContentIndex;
import org.apache.maven.archiva.indexer.RepositoryContentIndexFactory;
import org.apache.maven.archiva.indexer.RepositoryIndexException;
import org.apache.maven.archiva.indexer.bytecode.BytecodeRecord;
import org.apache.maven.archiva.indexer.filecontent.FileContentRecord;
import org.apache.maven.archiva.indexer.hashcodes.HashcodesRecord;
import org.apache.maven.archiva.indexer.lucene.LuceneRepositoryContentRecord;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneCleanupRemoveIndexedConsumer
extends AbstractMonitoredConsumer
implements DatabaseCleanupConsumer {
    private String id;
    private String description;
    private RepositoryContentIndexFactory repoIndexFactory;
    private RepositoryContentFactory repoFactory;

    public void beginScan() {
    }

    public void completeScan() {
    }

    public List<String> getIncludedTypes() {
        return null;
    }

    public void processArchivaArtifact(ArchivaArtifact artifact) throws ConsumerException {
        try {
            ManagedRepositoryContent repoContent = this.repoFactory.getManagedRepositoryContent(artifact.getModel().getRepositoryId());
            File file = new File(repoContent.getRepoRoot(), repoContent.toPath(artifact));
            if (!file.exists()) {
                RepositoryContentIndex bytecodeIndex = this.repoIndexFactory.createBytecodeIndex(repoContent.getRepository());
                RepositoryContentIndex hashcodesIndex = this.repoIndexFactory.createHashcodeIndex(repoContent.getRepository());
                RepositoryContentIndex fileContentIndex = this.repoIndexFactory.createFileContentIndex(repoContent.getRepository());
                FileContentRecord fileContentRecord = new FileContentRecord();
                fileContentRecord.setFilename(repoContent.toPath(artifact));
                fileContentIndex.deleteRecord((LuceneRepositoryContentRecord)fileContentRecord);
                HashcodesRecord hashcodesRecord = new HashcodesRecord();
                hashcodesRecord.setArtifact(artifact);
                hashcodesIndex.deleteRecord((LuceneRepositoryContentRecord)hashcodesRecord);
                BytecodeRecord bytecodeRecord = new BytecodeRecord();
                bytecodeRecord.setArtifact(artifact);
                bytecodeIndex.deleteRecord((LuceneRepositoryContentRecord)bytecodeRecord);
            }
        }
        catch (RepositoryException e) {
            throw new ConsumerException("Can't run index cleanup consumer: " + e.getMessage());
        }
        catch (RepositoryIndexException e) {
            throw new ConsumerException(e.getMessage());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPermanent() {
        return false;
    }

    public void setRepositoryIndexFactory(RepositoryContentIndexFactory repoIndexFactory) {
        this.repoIndexFactory = repoIndexFactory;
    }

    public void setRepositoryContentFactory(RepositoryContentFactory repoFactory) {
        this.repoFactory = repoFactory;
    }
}

