/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.lucene;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.database.updater.DatabaseCleanupConsumer;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.DefaultArtifactContextProducer;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneCleanupRemoveIndexedConsumer
extends AbstractMonitoredConsumer
implements DatabaseCleanupConsumer {
    private static final Logger log = LoggerFactory.getLogger(LuceneCleanupRemoveIndexedConsumer.class);
    private RepositoryContentFactory repoFactory;
    private NexusIndexer indexer;
    private ArtifactContextProducer artifactContextProducer;
    private IndexingContext context;

    public LuceneCleanupRemoveIndexedConsumer(RepositoryContentFactory repoFactory, NexusIndexer indexer) {
        this.repoFactory = repoFactory;
        this.indexer = indexer;
        this.artifactContextProducer = new DefaultArtifactContextProducer();
    }

    public void beginScan() {
    }

    public void completeScan() {
        try {
            this.context.getIndexWriter().close();
            this.indexer.removeIndexingContext(this.context, false);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public List<String> getIncludedTypes() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processArchivaArtifact(ArchivaArtifact artifact) throws ConsumerException {
        try {
            ManagedRepositoryContent repoContent = this.repoFactory.getManagedRepositoryContent(artifact.getModel().getRepositoryId());
            ManagedRepositoryConfiguration repository = repoContent.getRepository();
            String indexDir = repository.getIndexDir();
            File managedRepository = new File(repository.getLocation());
            File indexDirectory = null;
            indexDirectory = indexDir != null && !"".equals(indexDir) ? new File(repository.getIndexDir()) : new File(managedRepository, ".indexer");
            NexusIndexer nexusIndexer = this.indexer;
            synchronized (nexusIndexer) {
                try {
                    ArtifactContext artifactContext;
                    this.context = this.indexer.addIndexingContext(repository.getId(), repository.getId(), managedRepository, indexDirectory, null, null, NexusIndexer.FULL_INDEX);
                    this.context.setSearchable(repository.isScanned());
                    File artifactFile = new File(repoContent.getRepoRoot(), repoContent.toPath(artifact));
                    if (!artifactFile.exists() && (artifactContext = this.artifactContextProducer.getArtifactContext(this.context, artifactFile)) != null) {
                        this.removeDocuments(artifactContext);
                    }
                }
                catch (UnsupportedExistingLuceneIndexException e) {
                    log.error("Unsupported index format.", (Throwable)e);
                }
                catch (IOException e) {
                    log.error("Unable to open index at " + indexDirectory.getAbsoluteFile(), (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            throw new ConsumerException("Can't run index cleanup consumer: " + e.getMessage());
        }
    }

    private void removeDocuments(ArtifactContext ac) throws IOException {
        IndexWriter w = this.context.getIndexWriter();
        ArtifactInfo ai = ac.getArtifactInfo();
        String uinfo = AbstractIndexCreator.getGAV((String)ai.groupId, (String)ai.artifactId, (String)ai.version, (String)ai.classifier, (String)ai.packaging);
        Document doc = new Document();
        doc.add((Fieldable)new Field("del", uinfo, Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field("m", Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
        w.addDocument(doc);
        w.deleteDocuments(new Term("u", uinfo));
        w.commit();
        this.context.updateTimestamp();
    }

    public String getDescription() {
        return "Remove indexed content if not present on filesystem.";
    }

    public String getId() {
        return "not-present-remove-indexed";
    }

    public boolean isPermanent() {
        return false;
    }

    public void setRepositoryContentFactory(RepositoryContentFactory repoFactory) {
        this.repoFactory = repoFactory;
    }

    public void setArtifactContextProducer(ArtifactContextProducer artifactContextProducer) {
        this.artifactContextProducer = artifactContextProducer;
    }
}

