/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.consumers.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.maven.archiva.consumers.ConsumerException;
import org.apache.maven.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.maven.archiva.repository.content.ManagedDefaultRepositoryContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.DefaultArtifactContextProducer;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;
import org.sonatype.nexus.index.creator.IndexerEngine;
import org.sonatype.nexus.index.packer.IndexPacker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusIndexerConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer {
    private static final Logger log = LoggerFactory.getLogger(NexusIndexerConsumer.class);
    private NexusIndexer indexer;
    private ArtifactContextProducer artifactContextProducer;
    private IndexPacker indexPacker;
    private ManagedDefaultRepositoryContent repositoryContent;
    private IndexingContext context;
    private File managedRepository;
    private IndexerEngine indexerEngine;
    private Set<String> uinfos;

    public NexusIndexerConsumer(NexusIndexer indexer, IndexPacker indexPacker, IndexerEngine indexerEngine) {
        this.indexer = indexer;
        this.indexPacker = indexPacker;
        this.indexerEngine = indexerEngine;
        this.artifactContextProducer = new DefaultArtifactContextProducer();
    }

    public String getDescription() {
        return "Indexes the repository to provide search and IDE integration features";
    }

    public String getId() {
        return "index-content";
    }

    public boolean isPermanent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginScan(ManagedRepositoryConfiguration repository, Date whenGathered) throws ConsumerException {
        this.managedRepository = new File(repository.getLocation());
        String indexDir = repository.getIndexDir();
        File indexDirectory = null;
        indexDirectory = indexDir != null && !"".equals(indexDir) ? new File(repository.getIndexDir()) : new File(this.managedRepository, ".indexer");
        this.repositoryContent = new ManagedDefaultRepositoryContent();
        this.repositoryContent.setRepository(repository);
        this.uinfos = new HashSet<String>();
        NexusIndexer nexusIndexer = this.indexer;
        synchronized (nexusIndexer) {
            try {
                this.context = this.indexer.addIndexingContext(repository.getId(), repository.getId(), this.managedRepository, indexDirectory, null, null, NexusIndexer.FULL_INDEX);
                this.context.setSearchable(repository.isScanned());
                IndexReader r = this.context.getIndexReader();
                for (int i = 0; i < r.numDocs(); ++i) {
                    Document d;
                    String uinfo;
                    if (r.isDeleted(i) || (uinfo = (d = r.document(i)).get("u")) == null) continue;
                    this.uinfos.add(uinfo);
                }
                this.indexerEngine.beginIndexing(this.context);
            }
            catch (UnsupportedExistingLuceneIndexException e) {
                throw new ConsumerException("Could not create index at " + indexDirectory.getAbsoluteFile(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ConsumerException("Could not create index at " + indexDirectory.getAbsoluteFile(), (Throwable)e);
            }
        }
    }

    public void processFile(String path) throws ConsumerException {
        if (this.context == null) {
            return;
        }
        File artifactFile = new File(this.managedRepository, path);
        ArtifactContext artifactContext = this.artifactContextProducer.getArtifactContext(this.context, artifactFile);
        if (artifactContext != null) {
            try {
                ArtifactInfo ai = artifactContext.getArtifactInfo();
                String uinfo = AbstractIndexCreator.getGAV((String)ai.groupId, (String)ai.artifactId, (String)ai.version, (String)ai.classifier, (String)ai.packaging);
                if (this.uinfos.contains(uinfo)) {
                    this.indexerEngine.update(this.context, artifactContext);
                } else {
                    this.indexerEngine.index(this.context, artifactContext);
                }
            }
            catch (ZipException e) {
                log.info(e.getMessage());
            }
            catch (IOException e) {
                throw new ConsumerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeScan() {
        NexusIndexer nexusIndexer = this.indexer;
        synchronized (nexusIndexer) {
            File indexLocation = new File(this.managedRepository, ".index");
            try {
                this.indexerEngine.endIndexing(this.context);
                this.indexPacker.packIndex(this.context, indexLocation);
                this.indexer.removeIndexingContext(this.context, false);
                this.uinfos = null;
            }
            catch (IOException e) {
                log.error("Could not pack index" + indexLocation.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public List<String> getExcludes() {
        return new ArrayList<String>();
    }

    public List<String> getIncludes() {
        return Arrays.asList("**/*");
    }
}

