/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.model;

import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.model.Dependency;

public class DependencyScope {
    public static final String SYSTEM = "system";
    public static final String COMPILE = "compile";
    public static final String PROVIDED = "provided";
    public static final String RUNTIME = "runtime";
    public static final String TEST = "test";
    private static final MultiValueMap scopeMap = new MultiValueMap();

    public static boolean isSystemScoped(Dependency dep) {
        return StringUtils.equals((String)SYSTEM, (String)dep.getScope());
    }

    public static boolean isWithinScope(String actualScope, String desiredScope) {
        if (StringUtils.isBlank((String)desiredScope)) {
            return false;
        }
        String scope = StringUtils.defaultIfEmpty((String)actualScope, (String)COMPILE);
        return scopeMap.containsValue((Object)desiredScope, (Object)scope);
    }

    static {
        scopeMap.put((Object)COMPILE, (Object)COMPILE);
        scopeMap.put((Object)COMPILE, (Object)RUNTIME);
        scopeMap.put((Object)COMPILE, (Object)PROVIDED);
        scopeMap.put((Object)COMPILE, (Object)SYSTEM);
        scopeMap.put((Object)TEST, (Object)COMPILE);
        scopeMap.put((Object)TEST, (Object)RUNTIME);
        scopeMap.put((Object)TEST, (Object)PROVIDED);
        scopeMap.put((Object)TEST, (Object)SYSTEM);
        scopeMap.put((Object)TEST, (Object)TEST);
        scopeMap.put((Object)RUNTIME, (Object)RUNTIME);
        scopeMap.put((Object)RUNTIME, (Object)PROVIDED);
        scopeMap.put((Object)RUNTIME, (Object)SYSTEM);
        scopeMap.put((Object)PROVIDED, (Object)RUNTIME);
        scopeMap.put((Object)PROVIDED, (Object)PROVIDED);
        scopeMap.put((Object)PROVIDED, (Object)SYSTEM);
        scopeMap.put((Object)SYSTEM, (Object)SYSTEM);
    }
}

