/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Specifies the organization that produces this project.
 * 
 * @version $Revision$ $Date$
 */
public class Organization
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The generated id of the organization object. Due to problems
     * in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     */
    private String name;

    /**
     * The full name of the organization.
     */
    private String organizationName;

    /**
     * The URL to the organization's home page.
     */
    private String url;

    /**
     * 
     *             The URL to the organization's logo image.  This
     * can be an URL relative
     *             to the base directory of the generated web site,
     *             (e.g., <code>/images/org-logo.png</code>) or an
     * absolute URL
     *             (e.g., <code>http://my.corp/logo.png</code>). 
     * This value is used
     *             when generating the project documentation.
     *           
     */
    private String favicon;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof Organization ) )
        {
            return false;
        }

        Organization that = (Organization) other;
        boolean result = true;

        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             The URL to the organization's logo image.  This
     * can be an URL relative
     *             to the base directory of the generated web site,
     *             (e.g., <code>/images/org-logo.png</code>) or an
     * absolute URL
     *             (e.g., <code>http://my.corp/logo.png</code>). 
     * This value is used
     *             when generating the project documentation.
     *           
     * 
     * @return String
     */
    public String getFavicon()
    {
        return this.favicon;
    } //-- String getFavicon()

    /**
     * Get the generated id of the organization object. Due to
     * problems in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get the full name of the organization.
     * 
     * @return String
     */
    public String getOrganizationName()
    {
        return this.organizationName;
    } //-- String getOrganizationName()

    /**
     * Get the URL to the organization's home page.
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( name != null ? name.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set 
     *             The URL to the organization's logo image.  This
     * can be an URL relative
     *             to the base directory of the generated web site,
     *             (e.g., <code>/images/org-logo.png</code>) or an
     * absolute URL
     *             (e.g., <code>http://my.corp/logo.png</code>). 
     * This value is used
     *             when generating the project documentation.
     *           
     * 
     * @param favicon
     */
    public void setFavicon( String favicon )
    {
        this.favicon = favicon;
    } //-- void setFavicon( String )

    /**
     * Set the generated id of the organization object. Due to
     * problems in upgrading, 
     *           we cannot unset this as the identifier and we
     * cannot rename this as well.
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the full name of the organization.
     * 
     * @param organizationName
     */
    public void setOrganizationName( String organizationName )
    {
        this.organizationName = organizationName;
    } //-- void setOrganizationName( String )

    /**
     * Set the URL to the organization's home page.
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


    private static final long serialVersionUID = -7782212828768434535L;
          
}
