/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.model;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.model.CompoundKey;

public class AbstractArtifactKey
implements CompoundKey,
Serializable {
    private static final long serialVersionUID = 1084250769223555422L;
    public String groupId = "";
    public String artifactId = "";
    public String version = "";
    public String classifier = "";
    public String type = "";
    public String repositoryId = "";

    public AbstractArtifactKey() {
    }

    public AbstractArtifactKey(String key) {
        String[] parts = StringUtils.splitPreserveAllTokens((String)key, (String)":");
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.version = parts[2];
        this.classifier = parts[3];
        this.type = parts[4];
        this.repositoryId = parts[5];
    }

    public String toString() {
        return StringUtils.join((Object[])new String[]{this.groupId, this.artifactId, this.version, this.classifier, this.type, this.repositoryId}, (char)':');
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.repositoryId == null ? 0 : this.repositoryId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractArtifactKey other = (AbstractArtifactKey)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.repositoryId == null ? other.repositoryId != null : !this.repositoryId.equals(other.repositoryId));
    }

    public void setGroupId(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("A blank Group ID is not allowed.");
        }
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        if (StringUtils.isBlank((String)artifactId)) {
            throw new IllegalArgumentException("A blank Artifact ID is not allowed.");
        }
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        if (StringUtils.isBlank((String)this.artifactId)) {
            throw new IllegalArgumentException("A blank version is not allowed.");
        }
        this.version = version;
    }

    public void setClassifier(String classifier) {
        this.classifier = "";
        if (StringUtils.isNotBlank((String)classifier)) {
            this.classifier = classifier;
        }
    }

    public void setType(String type) {
        this.type = "";
        if (StringUtils.isNotBlank((String)type)) {
            this.type = type;
        }
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = "";
        if (StringUtils.isNotBlank((String)repositoryId)) {
            this.repositoryId = repositoryId;
        }
    }
}

