/*
 * $Id$
 */

package org.apache.maven.archiva.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class ArchivaArtifactModel.
 * 
 * @version $Revision$ $Date$
 */
public class ArchivaArtifactModel
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The Group ID of the repository content.
     *           
     */
    private String groupId;

    /**
     * 
     *             The Artifact ID of the repository content.
     *           
     */
    private String artifactId;

    /**
     * 
     *             The version of the repository content.
     *           
     */
    private String version;

    /**
     * 
     *             The classifier for this artifact.
     *           
     */
    private String classifier;

    /**
     * 
     *             The type of artifact.
     *           
     */
    private String type;

    /**
     * 
     *             The repository associated with this content.
     *           
     */
    private String repositoryId;

    /**
     * 
     *             True if this is a snapshot.
     *           
     */
    private boolean snapshot = false;

    /**
     * 
     *             The MD5 checksum for the artifact file.
     *           
     */
    private String checksumMD5;

    /**
     * 
     *             The SHA1 checksum for the artifact file.
     *           
     */
    private String checksumSHA1;

    /**
     * 
     *             The Last Modified Timestamp of this artifact.
     *           
     */
    private java.util.Date lastModified;

    /**
     * 
     *             The size of the artifact on disk.
     *           
     */
    private long size = 0L;

    /**
     * 
     *             The platform of this artifact. (default: "java")
     *           .
     */
    private String platform = "java";

    /**
     * 
     *             The timestamp when this artifact was indexed.
     *           
     */
    private java.util.Date whenIndexed;

    /**
     * 
     *             When this artifact's contents was processed.
     *           
     */
    private java.util.Date whenProcessed;

    /**
     * 
     *             The origin of this artifact. (Filesystem, Proxy,
     * Deploy)
     *           .
     */
    private String origin;

    /**
     * 
     *             When this artifact was gathered or discovered
     * from the repository.
     *           
     */
    private java.util.Date whenGathered;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof ArchivaArtifactModel ) )
        {
            return false;
        }

        ArchivaArtifactModel that = (ArchivaArtifactModel) other;
        boolean result = true;

        result = result && ( getGroupId() == null ? that.getGroupId() == null : getGroupId().equals( that.getGroupId() ) );
        result = result && ( getArtifactId() == null ? that.getArtifactId() == null : getArtifactId().equals( that.getArtifactId() ) );
        result = result && ( getVersion() == null ? that.getVersion() == null : getVersion().equals( that.getVersion() ) );
        result = result && ( getClassifier() == null ? that.getClassifier() == null : getClassifier().equals( that.getClassifier() ) );
        result = result && ( getType() == null ? that.getType() == null : getType().equals( that.getType() ) );
        result = result && ( getRepositoryId() == null ? that.getRepositoryId() == null : getRepositoryId().equals( that.getRepositoryId() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get 
     *             The MD5 checksum for the artifact file.
     *           
     * 
     * @return String
     */
    public String getChecksumMD5()
    {
        return this.checksumMD5;
    } //-- String getChecksumMD5()

    /**
     * Get 
     *             The SHA1 checksum for the artifact file.
     *           
     * 
     * @return String
     */
    public String getChecksumSHA1()
    {
        return this.checksumSHA1;
    } //-- String getChecksumSHA1()

    /**
     * Get 
     *             The classifier for this artifact.
     *           
     * 
     * @return String
     */
    public String getClassifier()
    {
        return this.classifier;
    } //-- String getClassifier()

    /**
     * Get 
     *             The Group ID of the repository content.
     *           
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Get 
     *             The Last Modified Timestamp of this artifact.
     *           
     * 
     * @return Date
     */
    public java.util.Date getLastModified()
    {
        return this.lastModified;
    } //-- java.util.Date getLastModified()

    /**
     * Get 
     *             The origin of this artifact. (Filesystem, Proxy,
     * Deploy)
     *           .
     * 
     * @return String
     */
    public String getOrigin()
    {
        return this.origin;
    } //-- String getOrigin()

    /**
     * Get 
     *             The platform of this artifact. (default: "java")
     *           .
     * 
     * @return String
     */
    public String getPlatform()
    {
        return this.platform;
    } //-- String getPlatform()

    /**
     * Get 
     *             The repository associated with this content.
     *           
     * 
     * @return String
     */
    public String getRepositoryId()
    {
        return this.repositoryId;
    } //-- String getRepositoryId()

    /**
     * Get 
     *             The size of the artifact on disk.
     *           
     * 
     * @return long
     */
    public long getSize()
    {
        return this.size;
    } //-- long getSize()

    /**
     * Get 
     *             The type of artifact.
     *           
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType()

    /**
     * Get 
     *             The version of the repository content.
     *           
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Get 
     *             When this artifact was gathered or discovered
     * from the repository.
     *           
     * 
     * @return Date
     */
    public java.util.Date getWhenGathered()
    {
        return this.whenGathered;
    } //-- java.util.Date getWhenGathered()

    /**
     * Get 
     *             The timestamp when this artifact was indexed.
     *           
     * 
     * @return Date
     */
    public java.util.Date getWhenIndexed()
    {
        return this.whenIndexed;
    } //-- java.util.Date getWhenIndexed()

    /**
     * Get 
     *             When this artifact's contents was processed.
     *           
     * 
     * @return Date
     */
    public java.util.Date getWhenProcessed()
    {
        return this.whenProcessed;
    } //-- java.util.Date getWhenProcessed()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( groupId != null ? groupId.hashCode() : 0 );
        result = 37 * result + ( artifactId != null ? artifactId.hashCode() : 0 );
        result = 37 * result + ( version != null ? version.hashCode() : 0 );
        result = 37 * result + ( classifier != null ? classifier.hashCode() : 0 );
        result = 37 * result + ( type != null ? type.hashCode() : 0 );
        result = 37 * result + ( repositoryId != null ? repositoryId.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Get 
     *             True if this is a snapshot.
     *           
     * 
     * @return boolean
     */
    public boolean isSnapshot()
    {
        return this.snapshot;
    } //-- boolean isSnapshot()

    /**
     * Set 
     *             The Artifact ID of the repository content.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set 
     *             The MD5 checksum for the artifact file.
     *           
     * 
     * @param checksumMD5
     */
    public void setChecksumMD5( String checksumMD5 )
    {
        this.checksumMD5 = checksumMD5;
    } //-- void setChecksumMD5( String )

    /**
     * Set 
     *             The SHA1 checksum for the artifact file.
     *           
     * 
     * @param checksumSHA1
     */
    public void setChecksumSHA1( String checksumSHA1 )
    {
        this.checksumSHA1 = checksumSHA1;
    } //-- void setChecksumSHA1( String )

    /**
     * Set 
     *             The classifier for this artifact.
     *           
     * 
     * @param classifier
     */
    public void setClassifier( String classifier )
    {
        this.classifier = classifier;
    } //-- void setClassifier( String )

    /**
     * Set 
     *             The Group ID of the repository content.
     *           
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set 
     *             The Last Modified Timestamp of this artifact.
     *           
     * 
     * @param lastModified
     */
    public void setLastModified( java.util.Date lastModified )
    {
        this.lastModified = lastModified;
    } //-- void setLastModified( java.util.Date )

    /**
     * Set 
     *             The origin of this artifact. (Filesystem, Proxy,
     * Deploy)
     *           .
     * 
     * @param origin
     */
    public void setOrigin( String origin )
    {
        this.origin = origin;
    } //-- void setOrigin( String )

    /**
     * Set 
     *             The platform of this artifact. (default: "java")
     *           .
     * 
     * @param platform
     */
    public void setPlatform( String platform )
    {
        this.platform = platform;
    } //-- void setPlatform( String )

    /**
     * Set 
     *             The repository associated with this content.
     *           
     * 
     * @param repositoryId
     */
    public void setRepositoryId( String repositoryId )
    {
        this.repositoryId = repositoryId;
    } //-- void setRepositoryId( String )

    /**
     * Set 
     *             The size of the artifact on disk.
     *           
     * 
     * @param size
     */
    public void setSize( long size )
    {
        this.size = size;
    } //-- void setSize( long )

    /**
     * Set 
     *             True if this is a snapshot.
     *           
     * 
     * @param snapshot
     */
    public void setSnapshot( boolean snapshot )
    {
        this.snapshot = snapshot;
    } //-- void setSnapshot( boolean )

    /**
     * Set 
     *             The type of artifact.
     *           
     * 
     * @param type
     */
    public void setType( String type )
    {
        this.type = type;
    } //-- void setType( String )

    /**
     * Set 
     *             The version of the repository content.
     *           
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

    /**
     * Set 
     *             When this artifact was gathered or discovered
     * from the repository.
     *           
     * 
     * @param whenGathered
     */
    public void setWhenGathered( java.util.Date whenGathered )
    {
        this.whenGathered = whenGathered;
    } //-- void setWhenGathered( java.util.Date )

    /**
     * Set 
     *             The timestamp when this artifact was indexed.
     *           
     * 
     * @param whenIndexed
     */
    public void setWhenIndexed( java.util.Date whenIndexed )
    {
        this.whenIndexed = whenIndexed;
    } //-- void setWhenIndexed( java.util.Date )

    /**
     * Set 
     *             When this artifact's contents was processed.
     *           
     * 
     * @param whenProcessed
     */
    public void setWhenProcessed( java.util.Date whenProcessed )
    {
        this.whenProcessed = whenProcessed;
    } //-- void setWhenProcessed( java.util.Date )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "groupId = '" );
        buf.append( getGroupId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "artifactId = '" );
        buf.append( getArtifactId() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "version = '" );
        buf.append( getVersion() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "classifier = '" );
        buf.append( getClassifier() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "type = '" );
        buf.append( getType() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "repositoryId = '" );
        buf.append( getRepositoryId() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


    private static final long serialVersionUID = -6292417108113887384L;
          
    /**
     * Identify if this artifact's contents have been processed or not.
     * 
     * @return true if the artifact's contents have been processed.
     */
    public boolean isProcessed()
    {
        return !(whenProcessed == null);
    }          
          
}
