/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.proxy;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.beans.ProxyConnectorRuleType;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.networkproxy.NetworkProxyAdmin;
import org.apache.archiva.common.filelock.FileLockException;
import org.apache.archiva.common.filelock.FileLockManager;
import org.apache.archiva.common.filelock.FileLockTimeoutException;
import org.apache.archiva.common.filelock.Lock;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.NetworkProxyConfiguration;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.configuration.ProxyConnectorRuleConfiguration;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.Keys;
import org.apache.archiva.model.RepositoryURL;
import org.apache.archiva.policies.DownloadErrorPolicy;
import org.apache.archiva.policies.DownloadPolicy;
import org.apache.archiva.policies.PolicyConfigurationException;
import org.apache.archiva.policies.PolicyViolationException;
import org.apache.archiva.policies.PostDownloadPolicy;
import org.apache.archiva.policies.PreDownloadPolicy;
import org.apache.archiva.policies.ProxyDownloadException;
import org.apache.archiva.policies.urlcache.UrlFailureCache;
import org.apache.archiva.proxy.NotFoundException;
import org.apache.archiva.proxy.NotModifiedException;
import org.apache.archiva.proxy.ProxyConnectorOrderComparator;
import org.apache.archiva.proxy.ProxyException;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.proxy.common.WagonFactoryException;
import org.apache.archiva.proxy.common.WagonFactoryRequest;
import org.apache.archiva.proxy.model.ProxyConnector;
import org.apache.archiva.proxy.model.RepositoryProxyConnectors;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.TaskQueueException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RemoteRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.repository.metadata.MetadataTools;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.scheduler.ArchivaTaskScheduler;
import org.apache.archiva.scheduler.repository.model.RepositoryTask;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.springframework.stereotype.Service;

@Service(value="repositoryProxyConnectors#default")
public class DefaultRepositoryProxyConnectors
implements RepositoryProxyConnectors,
RegistryListener {
    private Logger log = LoggerFactory.getLogger(DefaultRepositoryProxyConnectors.class);
    @Inject
    @Named(value="archivaConfiguration#default")
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    @Named(value="repositoryContentFactory#default")
    private RepositoryContentFactory repositoryFactory;
    @Inject
    @Named(value="metadataTools#default")
    private MetadataTools metadataTools;
    @Inject
    private Map<String, PreDownloadPolicy> preDownloadPolicies;
    @Inject
    private Map<String, PostDownloadPolicy> postDownloadPolicies;
    @Inject
    private Map<String, DownloadErrorPolicy> downloadErrorPolicies;
    @Inject
    private UrlFailureCache urlFailureCache;
    private Map<String, List<ProxyConnector>> proxyConnectorMap = new HashMap<String, List<ProxyConnector>>();
    private Map<String, ProxyInfo> networkProxyMap = new ConcurrentHashMap<String, ProxyInfo>();
    @Inject
    private WagonFactory wagonFactory;
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private ArchivaTaskScheduler scheduler;
    @Inject
    private NetworkProxyAdmin networkProxyAdmin;
    @Inject
    @Named(value="fileLockManager#default")
    private FileLockManager fileLockManager;

    @PostConstruct
    public void initialize() {
        this.initConnectorsAndNetworkProxies();
        this.archivaConfiguration.addChangeListener((RegistryListener)this);
    }

    private void initConnectorsAndNetworkProxies() {
        ProxyConnectorOrderComparator proxyOrderSorter = new ProxyConnectorOrderComparator();
        this.proxyConnectorMap.clear();
        Configuration configuration = this.archivaConfiguration.getConfiguration();
        List allProxyConnectorRuleConfigurations = configuration.getProxyConnectorRuleConfigurations();
        List proxyConfigs = configuration.getProxyConnectors();
        for (ProxyConnectorConfiguration proxyConfig : proxyConfigs) {
            String key = proxyConfig.getSourceRepoId();
            try {
                List<ProxyConnector> connectors;
                ProxyConnector connector = new ProxyConnector();
                connector.setSourceRepository(this.repositoryFactory.getManagedRepositoryContent(proxyConfig.getSourceRepoId()));
                connector.setTargetRepository(this.repositoryFactory.getRemoteRepositoryContent(proxyConfig.getTargetRepoId()));
                connector.setProxyId(proxyConfig.getProxyId());
                connector.setPolicies(proxyConfig.getPolicies());
                connector.setOrder(proxyConfig.getOrder());
                connector.setDisabled(proxyConfig.isDisabled());
                ArrayList blacklist = new ArrayList(0);
                if (CollectionUtils.isNotEmpty((Collection)proxyConfig.getBlackListPatterns())) {
                    blacklist.addAll(proxyConfig.getBlackListPatterns());
                }
                connector.setBlacklist(blacklist);
                ArrayList whitelist = new ArrayList(0);
                if (CollectionUtils.isNotEmpty((Collection)proxyConfig.getWhiteListPatterns())) {
                    whitelist.addAll(proxyConfig.getWhiteListPatterns());
                }
                connector.setWhitelist(whitelist);
                List<ProxyConnectorRuleConfiguration> proxyConnectorRuleConfigurations = this.findProxyConnectorRules(connector.getSourceRepository().getId(), connector.getTargetRepository().getId(), allProxyConnectorRuleConfigurations);
                if (!proxyConnectorRuleConfigurations.isEmpty()) {
                    for (ProxyConnectorRuleConfiguration proxyConnectorRuleConfiguration : proxyConnectorRuleConfigurations) {
                        if (StringUtils.equals((String)proxyConnectorRuleConfiguration.getRuleType(), (String)ProxyConnectorRuleType.BLACK_LIST.getRuleType())) {
                            connector.getBlacklist().add(proxyConnectorRuleConfiguration.getPattern());
                        }
                        if (!StringUtils.equals((String)proxyConnectorRuleConfiguration.getRuleType(), (String)ProxyConnectorRuleType.WHITE_LIST.getRuleType())) continue;
                        connector.getWhitelist().add(proxyConnectorRuleConfiguration.getPattern());
                    }
                }
                if ((connectors = this.proxyConnectorMap.get(key)) == null) {
                    connectors = new ArrayList<ProxyConnector>(1);
                }
                connectors.add(connector);
                Collections.sort(connectors, proxyOrderSorter);
                this.proxyConnectorMap.put(key, connectors);
            }
            catch (RepositoryNotFoundException e) {
                this.log.warn("Unable to use proxy connector: {}", (Object)e.getMessage(), (Object)e);
            }
            catch (RepositoryException e) {
                this.log.warn("Unable to use proxy connector: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.networkProxyMap.clear();
        List networkProxies = this.archivaConfiguration.getConfiguration().getNetworkProxies();
        for (NetworkProxyConfiguration networkProxyConfig : networkProxies) {
            String key = networkProxyConfig.getId();
            ProxyInfo proxy = new ProxyInfo();
            proxy.setType(networkProxyConfig.getProtocol());
            proxy.setHost(networkProxyConfig.getHost());
            proxy.setPort(networkProxyConfig.getPort());
            proxy.setUserName(networkProxyConfig.getUsername());
            proxy.setPassword(networkProxyConfig.getPassword());
            this.networkProxyMap.put(key, proxy);
        }
    }

    private List<ProxyConnectorRuleConfiguration> findProxyConnectorRules(String sourceRepository, String targetRepository, List<ProxyConnectorRuleConfiguration> all) {
        ArrayList<ProxyConnectorRuleConfiguration> proxyConnectorRuleConfigurations = new ArrayList<ProxyConnectorRuleConfiguration>();
        for (ProxyConnectorRuleConfiguration proxyConnectorRuleConfiguration : all) {
            for (ProxyConnectorConfiguration proxyConnector : proxyConnectorRuleConfiguration.getProxyConnectors()) {
                if (!StringUtils.equals((String)sourceRepository, (String)proxyConnector.getSourceRepoId()) || !StringUtils.equals((String)targetRepository, (String)proxyConnector.getTargetRepoId())) continue;
                proxyConnectorRuleConfigurations.add(proxyConnectorRuleConfiguration);
            }
        }
        return proxyConnectorRuleConfigurations;
    }

    public File fetchFromProxies(ManagedRepositoryContent repository, ArtifactReference artifact) throws ProxyDownloadException {
        File localFile = this.toLocalFile(repository, artifact);
        Properties requestProperties = new Properties();
        requestProperties.setProperty("filetype", "artifact");
        requestProperties.setProperty("version", artifact.getVersion());
        requestProperties.setProperty("managedRepositoryId", repository.getId());
        List<ProxyConnector> connectors = this.getProxyConnectors(repository);
        LinkedHashMap<String, Exception> previousExceptions = new LinkedHashMap<String, Exception>();
        for (ProxyConnector connector : connectors) {
            if (connector.isDisabled()) continue;
            RemoteRepositoryContent targetRepository = connector.getTargetRepository();
            requestProperties.setProperty("remoteRepositoryId", targetRepository.getId());
            String targetPath = targetRepository.toPath(artifact);
            if (SystemUtils.IS_OS_WINDOWS) {
                targetPath = FilenameUtils.separatorsToUnix((String)targetPath);
            }
            try {
                File downloadedFile = this.transferFile(connector, targetRepository, targetPath, repository, localFile, requestProperties, true);
                if (!this.fileExists(downloadedFile)) continue;
                this.log.debug("Successfully transferred: {}", (Object)downloadedFile.getAbsolutePath());
                return downloadedFile;
            }
            catch (NotFoundException e) {
                this.log.debug("Artifact {} not found on repository \"{}\".", (Object)Keys.toKey((ArtifactReference)artifact), (Object)targetRepository.getRepository().getId());
            }
            catch (NotModifiedException e) {
                this.log.debug("Artifact {} not updated on repository \"{}\".", (Object)Keys.toKey((ArtifactReference)artifact), (Object)targetRepository.getRepository().getId());
            }
            catch (RepositoryAdminException | ProxyException e) {
                this.validatePolicies(this.downloadErrorPolicies, connector.getPolicies(), requestProperties, artifact, targetRepository, localFile, (Exception)e, previousExceptions);
            }
        }
        if (!previousExceptions.isEmpty()) {
            throw new ProxyDownloadException("Failures occurred downloading from some remote repositories", previousExceptions);
        }
        this.log.debug("Exhausted all target repositories, artifact {} not found.", (Object)Keys.toKey((ArtifactReference)artifact));
        return null;
    }

    public File fetchFromProxies(ManagedRepositoryContent repository, String path) {
        File localFile = new File(repository.getRepoRoot(), path);
        if (localFile.exists()) {
            return null;
        }
        Properties requestProperties = new Properties();
        requestProperties.setProperty("filetype", "resource");
        requestProperties.setProperty("managedRepositoryId", repository.getId());
        List<ProxyConnector> connectors = this.getProxyConnectors(repository);
        for (ProxyConnector connector : connectors) {
            if (connector.isDisabled()) continue;
            RemoteRepositoryContent targetRepository = connector.getTargetRepository();
            requestProperties.setProperty("remoteRepositoryId", targetRepository.getId());
            String targetPath = path;
            try {
                File downloadedFile = this.transferFile(connector, targetRepository, targetPath, repository, localFile, requestProperties, false);
                if (!this.fileExists(downloadedFile)) continue;
                this.log.debug("Successfully transferred: {}", (Object)downloadedFile.getAbsolutePath());
                return downloadedFile;
            }
            catch (NotFoundException e) {
                this.log.debug("Resource {} not found on repository \"{}\".", (Object)path, (Object)targetRepository.getRepository().getId());
            }
            catch (NotModifiedException e) {
                this.log.debug("Resource {} not updated on repository \"{}\".", (Object)path, (Object)targetRepository.getRepository().getId());
            }
            catch (ProxyException e) {
                this.log.warn("Transfer error from repository {} for resource {}, continuing to next repository. Error message: {}", new Object[]{targetRepository.getRepository().getId(), path, e.getMessage()});
                this.log.debug(MarkerFactory.getDetachedMarker((String)"transfer.error"), "Transfer error from repository \"" + targetRepository.getRepository().getId() + "\" for resource " + path + ", continuing to next repository. Error message: {}", (Object)e.getMessage(), (Object)e);
            }
            catch (RepositoryAdminException e) {
                this.log.debug(MarkerFactory.getDetachedMarker((String)"transfer.error"), "Transfer error from repository {} for resource {}, continuing to next repository. Error message: {}", new Object[]{targetRepository.getRepository().getId(), path, e.getMessage(), e});
                this.log.debug(MarkerFactory.getDetachedMarker((String)"transfer.error"), "Full stack trace", (Throwable)e);
            }
        }
        this.log.debug("Exhausted all target repositories, resource {} not found.", (Object)path);
        return null;
    }

    public File fetchMetatadaFromProxies(ManagedRepositoryContent repository, String logicalPath) {
        File localFile = new File(repository.getRepoRoot(), logicalPath);
        Properties requestProperties = new Properties();
        requestProperties.setProperty("filetype", "metadata");
        boolean metadataNeedsUpdating = false;
        long originalTimestamp = this.getLastModified(localFile);
        List<ProxyConnector> connectors = this.getProxyConnectors(repository);
        for (ProxyConnector connector : connectors) {
            if (connector.isDisabled()) continue;
            RemoteRepositoryContent targetRepository = connector.getTargetRepository();
            File localRepoFile = this.toLocalRepoFile(repository, targetRepository, logicalPath);
            long originalMetadataTimestamp = this.getLastModified(localRepoFile);
            try {
                this.transferFile(connector, targetRepository, logicalPath, repository, localRepoFile, requestProperties, true);
                if (!this.hasBeenUpdated(localRepoFile, originalMetadataTimestamp)) continue;
                metadataNeedsUpdating = true;
            }
            catch (NotFoundException e) {
                this.log.debug("Metadata {} not found on remote repository '{}'.", new Object[]{logicalPath, targetRepository.getRepository().getId(), e});
            }
            catch (NotModifiedException e) {
                this.log.debug("Metadata {} not updated on remote repository '{}'.", new Object[]{logicalPath, targetRepository.getRepository().getId(), e});
            }
            catch (RepositoryAdminException | ProxyException e) {
                this.log.warn("Transfer error from repository {} for versioned Metadata {}, continuing to next repository. Error message: {}", new Object[]{targetRepository.getRepository().getId(), logicalPath, e.getMessage()});
                this.log.debug("Full stack trace", e);
            }
        }
        if (this.hasBeenUpdated(localFile, originalTimestamp)) {
            metadataNeedsUpdating = true;
        }
        if (metadataNeedsUpdating || !localFile.exists()) {
            try {
                this.metadataTools.updateMetadata(repository, logicalPath);
            }
            catch (RepositoryMetadataException e) {
                this.log.warn("Unable to update metadata {}:{}", new Object[]{localFile.getAbsolutePath(), e.getMessage(), e});
            }
        }
        if (this.fileExists(localFile)) {
            return localFile;
        }
        return null;
    }

    protected void transferResources(ProxyConnector connector, RemoteRepositoryContent remoteRepository, File tmpMd5, File tmpSha1, File tmpResource, String url, String remotePath, File resource, File workingDirectory, ManagedRepositoryContent repository) throws ProxyException, NotModifiedException, RepositoryAdminException {
        Wagon wagon = null;
        try {
            WagonFactoryRequest wagonFactoryRequest;
            RepositoryURL repoUrl = remoteRepository.getURL();
            String protocol = repoUrl.getProtocol();
            NetworkProxy networkProxy = null;
            if (StringUtils.isNotBlank((String)connector.getProxyId())) {
                networkProxy = this.networkProxyAdmin.getNetworkProxy(connector.getProxyId());
            }
            if ((wagon = this.wagonFactory.getWagon(wagonFactoryRequest = new WagonFactoryRequest("wagon#" + protocol, remoteRepository.getRepository().getExtraHeaders()).networkProxy(networkProxy))) == null) {
                throw new ProxyException("Unsupported target repository protocol: " + protocol);
            }
            if (wagon == null) {
                throw new ProxyException("Unsupported target repository protocol: " + protocol);
            }
            boolean connected = this.connectToRepository(connector, wagon, remoteRepository);
            if (connected) {
                this.transferArtifact(wagon, remoteRepository, remotePath, repository, resource, workingDirectory, tmpResource);
                this.transferChecksum(wagon, remoteRepository, remotePath, repository, resource, workingDirectory, ".sha1", tmpSha1);
                this.transferChecksum(wagon, remoteRepository, remotePath, repository, resource, workingDirectory, ".md5", tmpMd5);
            }
        }
        catch (NotFoundException e) {
            this.urlFailureCache.cacheFailure(url);
            throw e;
        }
        catch (NotModifiedException e) {
            throw e;
        }
        catch (ProxyException e) {
            this.urlFailureCache.cacheFailure(url);
            throw e;
        }
        catch (WagonFactoryException e) {
            throw new ProxyException(e.getMessage(), e);
        }
        finally {
            if (wagon != null) {
                try {
                    wagon.disconnect();
                }
                catch (ConnectionException e) {
                    this.log.warn("Unable to disconnect wagon.", (Throwable)e);
                }
            }
        }
    }

    private void transferArtifact(Wagon wagon, RemoteRepositoryContent remoteRepository, String remotePath, ManagedRepositoryContent repository, File resource, File tmpDirectory, File destFile) throws ProxyException {
        this.transferSimpleFile(wagon, remoteRepository, remotePath, repository, resource, destFile);
    }

    private long getLastModified(File file) {
        if (!file.exists() || !file.isFile()) {
            return 0L;
        }
        return file.lastModified();
    }

    private boolean hasBeenUpdated(File file, long originalLastModified) {
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        long currentLastModified = this.getLastModified(file);
        return currentLastModified > originalLastModified;
    }

    private File toLocalRepoFile(ManagedRepositoryContent repository, RemoteRepositoryContent targetRepository, String targetPath) {
        String repoPath = this.metadataTools.getRepositorySpecificName(targetRepository, targetPath);
        return new File(repository.getRepoRoot(), repoPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProxies(ManagedRepositoryContent repository) {
        Map<String, List<ProxyConnector>> map = this.proxyConnectorMap;
        synchronized (map) {
            return this.proxyConnectorMap.containsKey(repository.getId());
        }
    }

    private File toLocalFile(ManagedRepositoryContent repository, ArtifactReference artifact) {
        return repository.toFile(artifact);
    }

    private boolean fileExists(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        return file.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File transferFile(ProxyConnector connector, RemoteRepositoryContent remoteRepository, String remotePath, ManagedRepositoryContent repository, File resource, Properties requestProperties, boolean executeConsumers) throws ProxyException, NotModifiedException, RepositoryAdminException {
        block16: {
            String url = remoteRepository.getURL().getUrl();
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + remotePath;
            requestProperties.setProperty("url", url);
            if (CollectionUtils.isNotEmpty((Collection)connector.getWhitelist()) && !this.matchesPattern(remotePath, connector.getWhitelist())) {
                this.log.debug("Path [{}] is not part of defined whitelist (skipping transfer from repository [{}]).", (Object)remotePath, (Object)remoteRepository.getRepository().getName());
                return null;
            }
            if (this.matchesPattern(remotePath, connector.getBlacklist())) {
                this.log.debug("Path [{}] is part of blacklist (skipping transfer from repository [{}]).", (Object)remotePath, (Object)remoteRepository.getRepository().getName());
                return null;
            }
            try {
                this.validatePolicies(this.preDownloadPolicies, connector.getPolicies(), requestProperties, resource);
            }
            catch (PolicyViolationException e) {
                String emsg = "Transfer not attempted on " + url + " : " + e.getMessage();
                if (this.fileExists(resource)) {
                    this.log.debug("{} : using already present local file.", (Object)emsg);
                    return resource;
                }
                this.log.debug(emsg);
                return null;
            }
            File workingDirectory = this.createWorkingDirectory(repository);
            File tmpResource = new File(workingDirectory, resource.getName());
            File tmpMd5 = new File(workingDirectory, resource.getName() + ".md5");
            File tmpSha1 = new File(workingDirectory, resource.getName() + ".sha1");
            try {
                block15: {
                    this.transferResources(connector, remoteRepository, tmpMd5, tmpSha1, tmpResource, url, remotePath, resource, workingDirectory, repository);
                    try {
                        this.validatePolicies(this.postDownloadPolicies, connector.getPolicies(), requestProperties, tmpResource);
                    }
                    catch (PolicyViolationException e) {
                        this.log.warn("Transfer invalidated from {} : {}", (Object)url, (Object)e.getMessage());
                        executeConsumers = false;
                        if (this.fileExists(tmpResource)) break block15;
                        resource = null;
                    }
                }
                if (resource == null) break block16;
                String string = resource.getAbsolutePath().intern();
                synchronized (string) {
                    File directory = resource.getParentFile();
                    this.moveFileIfExists(tmpMd5, directory);
                    this.moveFileIfExists(tmpSha1, directory);
                    this.moveFileIfExists(tmpResource, directory);
                }
            }
            finally {
                FileUtils.deleteQuietly((File)workingDirectory);
            }
        }
        if (executeConsumers) {
            this.queueRepositoryTask(connector.getSourceRepository().getRepository().getId(), resource);
        }
        return resource;
    }

    private void queueRepositoryTask(String repositoryId, File localFile) {
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setResourceFile(localFile);
        task.setUpdateRelatedArtifacts(true);
        task.setScanAll(true);
        try {
            this.scheduler.queueTask((Task)task);
        }
        catch (TaskQueueException e) {
            this.log.error("Unable to queue repository task to execute consumers on resource file ['" + localFile.getName() + "'].");
        }
    }

    private void moveFileIfExists(File fileToMove, File directory) throws ProxyException {
        if (fileToMove != null && fileToMove.exists()) {
            File newLocation = new File(directory, fileToMove.getName());
            this.moveTempToTarget(fileToMove, newLocation);
        }
    }

    private void transferChecksum(Wagon wagon, RemoteRepositoryContent remoteRepository, String remotePath, ManagedRepositoryContent repository, File resource, File tmpDirectory, String ext, File destFile) throws ProxyException {
        String url = remoteRepository.getURL().getUrl() + remotePath + ext;
        if (this.urlFailureCache.hasFailedBefore(url)) {
            return;
        }
        try {
            this.transferSimpleFile(wagon, remoteRepository, remotePath + ext, repository, resource, destFile);
            this.log.debug("Checksum {} Downloaded: {} to move to {}", new Object[]{url, destFile, resource});
        }
        catch (NotFoundException e) {
            this.urlFailureCache.cacheFailure(url);
            this.log.debug("Transfer failed, checksum not found: {}", (Object)url);
        }
        catch (NotModifiedException e) {
            this.log.debug("Transfer skipped, checksum not modified: {}", (Object)url);
        }
        catch (ProxyException e) {
            this.urlFailureCache.cacheFailure(url);
            this.log.warn("Transfer failed on checksum: {} : {}", new Object[]{url, e.getMessage(), e});
            throw e;
        }
    }

    private void transferSimpleFile(Wagon wagon, RemoteRepositoryContent remoteRepository, String remotePath, ManagedRepositoryContent repository, File origFile, File destFile) throws ProxyException {
        assert (remotePath != null);
        try {
            boolean success = false;
            if (!origFile.exists()) {
                this.log.debug("Retrieving {} from {}", (Object)remotePath, (Object)remoteRepository.getRepository().getName());
                wagon.get(this.addParameters(remotePath, remoteRepository.getRepository()), destFile);
                success = true;
                this.log.debug("Downloaded successfully.");
            } else {
                this.log.debug("Retrieving {} from {} if updated", (Object)remotePath, (Object)remoteRepository.getRepository().getName());
                success = wagon.getIfNewer(this.addParameters(remotePath, remoteRepository.getRepository()), destFile, origFile.lastModified());
                if (!success) {
                    throw new NotModifiedException("Not downloaded, as local file is newer than remote side: " + origFile.getAbsolutePath());
                }
                if (destFile.exists()) {
                    this.log.debug("Downloaded successfully.");
                }
            }
        }
        catch (ResourceDoesNotExistException e) {
            throw new NotFoundException("Resource [" + remoteRepository.getURL() + "/" + remotePath + "] does not exist: " + e.getMessage(), e);
        }
        catch (WagonException e) {
            String msg = "Download failure on resource [" + remoteRepository.getURL() + "/" + remotePath + "]:" + e.getMessage();
            if (e.getCause() != null) {
                msg = msg + " (cause: " + e.getCause() + ")";
            }
            throw new ProxyException(msg, e);
        }
    }

    private void validatePolicies(Map<String, ? extends DownloadPolicy> policies, Map<String, String> settings, Properties request, File localFile) throws PolicyViolationException {
        for (Map.Entry<String, ? extends DownloadPolicy> entry : policies.entrySet()) {
            String key = StringUtils.substringAfterLast((String)entry.getKey(), (String)"#");
            DownloadPolicy policy = entry.getValue();
            String defaultSetting = policy.getDefaultOption();
            String setting = StringUtils.defaultString((String)settings.get(key), (String)defaultSetting);
            this.log.debug("Applying [{}] policy with [{}]", (Object)key, (Object)setting);
            try {
                policy.applyPolicy(setting, request, localFile);
            }
            catch (PolicyConfigurationException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void validatePolicies(Map<String, DownloadErrorPolicy> policies, Map<String, String> settings, Properties request, ArtifactReference artifact, RemoteRepositoryContent content, File localFile, Exception exception, Map<String, Exception> previousExceptions) throws ProxyDownloadException {
        boolean process = true;
        for (Map.Entry<String, DownloadErrorPolicy> entry : policies.entrySet()) {
            String key = StringUtils.substringAfterLast((String)entry.getKey(), (String)"#");
            DownloadErrorPolicy policy = entry.getValue();
            String defaultSetting = policy.getDefaultOption();
            String setting = StringUtils.defaultString((String)settings.get(key), (String)defaultSetting);
            this.log.debug("Applying [{}] policy with [{}]", (Object)key, (Object)setting);
            try {
                process = policy.applyPolicy(setting, request, localFile, exception, previousExceptions);
                if (process) continue;
                break;
            }
            catch (PolicyConfigurationException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (process) {
            if (!previousExceptions.containsKey(content.getId())) {
                throw new ProxyDownloadException("An error occurred in downloading from the remote repository, and the policy is to fail immediately", content.getId(), exception);
            }
        } else {
            previousExceptions.remove(content.getId());
        }
        this.log.warn("Transfer error from repository {} for artifact {} , continuing to next repository. Error message: {}", new Object[]{content.getRepository().getId(), Keys.toKey((ArtifactReference)artifact), exception.getMessage()});
        this.log.debug("Full stack trace", (Throwable)exception);
    }

    private File createWorkingDirectory(ManagedRepositoryContent repository) {
        try {
            return Files.createTempDirectory("temp", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTempToTarget(File temp, File target) throws ProxyException {
        block10: {
            Lock lock = null;
            try {
                lock = this.fileLockManager.writeFileLock(target);
                if (lock.getFile().exists() && !lock.getFile().delete()) {
                    throw new ProxyException("Unable to overwrite existing target file: " + target.getAbsolutePath());
                }
                lock.getFile().getParentFile().mkdirs();
                if (temp.renameTo(lock.getFile())) break block10;
                this.log.warn("Unable to rename tmp file to its final name... resorting to copy command.");
                try {
                    FileUtils.copyFile((File)temp, (File)lock.getFile());
                }
                catch (IOException e) {
                    if (lock.getFile().exists()) {
                        this.log.debug("Tried to copy file {} to {} but file with this name already exists.", (Object)temp.getName(), (Object)lock.getFile().getAbsolutePath());
                        break block10;
                    }
                    throw new ProxyException("Cannot copy tmp file " + temp.getAbsolutePath() + " to its final location", e);
                }
                finally {
                    FileUtils.deleteQuietly((File)temp);
                }
            }
            catch (FileLockException e) {
                throw new ProxyException(e.getMessage(), e);
            }
            catch (FileLockTimeoutException e) {
                throw new ProxyException(e.getMessage(), e);
            }
        }
    }

    private boolean connectToRepository(ProxyConnector connector, Wagon wagon, RemoteRepositoryContent remoteRepository) {
        ProxyInfo networkProxy;
        boolean connected = false;
        ProxyInfo proxyInfo = networkProxy = connector.getProxyId() == null ? null : this.networkProxyMap.get(connector.getProxyId());
        if (this.log.isDebugEnabled() && networkProxy != null) {
            String msg = "Using network proxy " + networkProxy.getHost() + ":" + networkProxy.getPort() + " to connect to remote repository " + remoteRepository.getURL();
            if (networkProxy.getNonProxyHosts() != null) {
                msg = msg + "; excluding hosts: " + networkProxy.getNonProxyHosts();
            }
            if (StringUtils.isNotBlank((String)networkProxy.getUserName())) {
                msg = msg + "; as user: " + networkProxy.getUserName();
            }
            this.log.debug(msg);
        }
        AuthenticationInfo authInfo = null;
        String username = remoteRepository.getRepository().getUserName();
        String password = remoteRepository.getRepository().getPassword();
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            this.log.debug("Using username {} to connect to remote repository {}", (Object)username, (Object)remoteRepository.getURL());
            authInfo = new AuthenticationInfo();
            authInfo.setUserName(username);
            authInfo.setPassword(password);
        }
        int timeoutInMilliseconds = remoteRepository.getRepository().getTimeout() * 1000;
        wagon.setReadTimeout(timeoutInMilliseconds);
        wagon.setTimeout(timeoutInMilliseconds);
        try {
            Repository wagonRepository = new Repository(remoteRepository.getId(), remoteRepository.getURL().toString());
            wagon.connect(wagonRepository, authInfo, networkProxy);
            connected = true;
        }
        catch (ConnectionException | AuthenticationException e) {
            this.log.warn("Could not connect to {}: {}", (Object)remoteRepository.getRepository().getName(), (Object)e.getMessage());
            connected = false;
        }
        return connected;
    }

    private boolean matchesPattern(String path, List<String> patterns) {
        if (CollectionUtils.isEmpty(patterns)) {
            return false;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        for (String pattern : patterns) {
            if (!pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
            if (!SelectorUtils.matchPath((String)pattern, (String)path, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProxyConnector> getProxyConnectors(ManagedRepositoryContent repository) {
        Map<String, List<ProxyConnector>> map = this.proxyConnectorMap;
        synchronized (map) {
            List<ProxyConnector> ret = this.proxyConnectorMap.get(repository.getId());
            if (ret == null) {
                return Collections.emptyList();
            }
            Collections.sort(ret, ProxyConnectorOrderComparator.getInstance());
            return ret;
        }
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isNetworkProxy((String)propertyName) || ConfigurationNames.isManagedRepositories((String)propertyName) || ConfigurationNames.isRemoteRepositories((String)propertyName) || ConfigurationNames.isProxyConnector((String)propertyName)) {
            this.initConnectorsAndNetworkProxies();
        }
    }

    protected String addParameters(String path, RemoteRepository remoteRepository) {
        if (remoteRepository.getExtraParameters().isEmpty()) {
            return path;
        }
        boolean question = false;
        StringBuilder res = new StringBuilder(path == null ? "" : path);
        for (Map.Entry entry : remoteRepository.getExtraParameters().entrySet()) {
            if (question) continue;
            res.append('?').append((String)entry.getKey()).append('=').append((String)entry.getValue());
        }
        return res.toString();
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    public ArchivaConfiguration getArchivaConfiguration() {
        return this.archivaConfiguration;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public RepositoryContentFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(RepositoryContentFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public MetadataTools getMetadataTools() {
        return this.metadataTools;
    }

    public void setMetadataTools(MetadataTools metadataTools) {
        this.metadataTools = metadataTools;
    }

    public UrlFailureCache getUrlFailureCache() {
        return this.urlFailureCache;
    }

    public void setUrlFailureCache(UrlFailureCache urlFailureCache) {
        this.urlFailureCache = urlFailureCache;
    }

    public WagonFactory getWagonFactory() {
        return this.wagonFactory;
    }

    public void setWagonFactory(WagonFactory wagonFactory) {
        this.wagonFactory = wagonFactory;
    }

    public Map<String, PreDownloadPolicy> getPreDownloadPolicies() {
        return this.preDownloadPolicies;
    }

    public void setPreDownloadPolicies(Map<String, PreDownloadPolicy> preDownloadPolicies) {
        this.preDownloadPolicies = preDownloadPolicies;
    }

    public Map<String, PostDownloadPolicy> getPostDownloadPolicies() {
        return this.postDownloadPolicies;
    }

    public void setPostDownloadPolicies(Map<String, PostDownloadPolicy> postDownloadPolicies) {
        this.postDownloadPolicies = postDownloadPolicies;
    }

    public Map<String, DownloadErrorPolicy> getDownloadErrorPolicies() {
        return this.downloadErrorPolicies;
    }

    public void setDownloadErrorPolicies(Map<String, DownloadErrorPolicy> downloadErrorPolicies) {
        this.downloadErrorPolicies = downloadErrorPolicies;
    }
}

