/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.archiva.admin.model.beans.FileType;
import org.apache.archiva.admin.model.beans.LegacyArtifactPath;
import org.apache.archiva.admin.model.beans.NetworkConfiguration;
import org.apache.archiva.admin.model.beans.OrganisationInformation;
import org.apache.archiva.admin.model.beans.UiConfiguration;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.model.AdminRepositoryConsumer;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/archivaAdministrationService/")
public interface ArchivaAdministrationService {
    @Path(value="getLegacyArtifactPaths")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<LegacyArtifactPath> getLegacyArtifactPaths() throws ArchivaRestServiceException;

    @Path(value="addLegacyArtifactPath")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void addLegacyArtifactPath(LegacyArtifactPath var1) throws ArchivaRestServiceException;

    @Path(value="deleteLegacyArtifactPath")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean deleteLegacyArtifactPath(@QueryParam(value="path") String var1) throws ArchivaRestServiceException;

    @Path(value="addFileTypePattern")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean addFileTypePattern(@QueryParam(value="fileTypeId") String var1, @QueryParam(value="pattern") String var2) throws ArchivaRestServiceException;

    @Path(value="removeFileTypePattern")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean removeFileTypePattern(@QueryParam(value="fileTypeId") String var1, @QueryParam(value="pattern") String var2) throws ArchivaRestServiceException;

    @Path(value="getFileType")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public FileType getFileType(@QueryParam(value="fileTypeId") String var1) throws ArchivaRestServiceException;

    @Path(value="addFileType")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void addFileType(FileType var1) throws ArchivaRestServiceException;

    @Path(value="removeFileType")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean removeFileType(@QueryParam(value="fileTypeId") String var1) throws ArchivaRestServiceException;

    @Path(value="enabledKnownContentConsumer/{knownContentConsumer}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean enabledKnownContentConsumer(@PathParam(value="knownContentConsumer") String var1) throws ArchivaRestServiceException;

    @Path(value="enabledKnownContentConsumers")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void enabledKnownContentConsumers(List<String> var1) throws ArchivaRestServiceException;

    @Path(value="disabledKnownContentConsumer/{knownContentConsumer}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean disabledKnownContentConsumer(@PathParam(value="knownContentConsumer") String var1) throws ArchivaRestServiceException;

    @Path(value="enabledInvalidContentConsumer/{invalidContentConsumer}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean enabledInvalidContentConsumer(@PathParam(value="invalidContentConsumer") String var1) throws ArchivaRestServiceException;

    @Path(value="enabledInvalidContentConsumers")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void enabledInvalidContentConsumers(List<String> var1) throws ArchivaRestServiceException;

    @Path(value="disabledInvalidContentConsumer/{invalidContentConsumer}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean disabledInvalidContentConsumer(@PathParam(value="invalidContentConsumer") String var1) throws ArchivaRestServiceException;

    @Path(value="getFileTypes")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<FileType> getFileTypes() throws ArchivaRestServiceException;

    @Path(value="getKnownContentConsumers")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<String> getKnownContentConsumers() throws ArchivaRestServiceException;

    @Path(value="getKnownContentAdminRepositoryConsumers")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<AdminRepositoryConsumer> getKnownContentAdminRepositoryConsumers() throws ArchivaRestServiceException;

    @Path(value="getInvalidContentAdminRepositoryConsumers")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<AdminRepositoryConsumer> getInvalidContentAdminRepositoryConsumers() throws ArchivaRestServiceException;

    @Path(value="getInvalidContentConsumers")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<String> getInvalidContentConsumers() throws ArchivaRestServiceException;

    @Path(value="getOrganisationInformation")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public OrganisationInformation getOrganisationInformation() throws ArchivaRestServiceException;

    @Path(value="setOrganisationInformation")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void setOrganisationInformation(OrganisationInformation var1) throws ArchivaRestServiceException;

    @Path(value="getUiConfiguration")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public UiConfiguration getUiConfiguration() throws ArchivaRestServiceException;

    @Path(value="registrationDisabled")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noRestriction=true, noPermission=true)
    public Boolean registrationDisabled() throws ArchivaRestServiceException;

    @Path(value="setUiConfiguration")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void setUiConfiguration(UiConfiguration var1) throws ArchivaRestServiceException;

    @Path(value="applicationUrl")
    @GET
    @Produces(value={"text/plain"})
    @RedbackAuthorization(noRestriction=true, noPermission=true)
    public String getApplicationUrl() throws ArchivaRestServiceException;

    @Path(value="getNetworkConfiguration")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public NetworkConfiguration getNetworkConfiguration() throws ArchivaRestServiceException;

    @Path(value="setNetworkConfiguration")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void setNetworkConfiguration(NetworkConfiguration var1) throws ArchivaRestServiceException;
}

