/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.model.PolicyInformation;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/proxyConnectorService/")
public interface ProxyConnectorService {
    @Path(value="getProxyConnectors")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<ProxyConnector> getProxyConnectors() throws ArchivaRestServiceException;

    @Path(value="getProxyConnector")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public ProxyConnector getProxyConnector(@QueryParam(value="sourceRepoId") String var1, @QueryParam(value="targetRepoId") String var2) throws ArchivaRestServiceException;

    @Path(value="addProxyConnector")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean addProxyConnector(ProxyConnector var1) throws ArchivaRestServiceException;

    @Path(value="deleteProxyConnector")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean deleteProxyConnector(ProxyConnector var1) throws ArchivaRestServiceException;

    @Path(value="removeProxyConnector")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean removeProxyConnector(@QueryParam(value="sourceRepoId") String var1, @QueryParam(value="targetRepoId") String var2) throws ArchivaRestServiceException;

    @Path(value="updateProxyConnector")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean updateProxyConnector(ProxyConnector var1) throws ArchivaRestServiceException;

    @Path(value="allPolicies")
    @GET
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<PolicyInformation> getAllPolicyInformations() throws ArchivaRestServiceException;
}

