/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/remoteRepositoriesService/")
public interface RemoteRepositoriesService {
    @Path(value="getRemoteRepositories")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<RemoteRepository> getRemoteRepositories() throws ArchivaRestServiceException;

    @Path(value="getRemoteRepository/{repositoryId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public RemoteRepository getRemoteRepository(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;

    @Path(value="deleteRemoteRepository/{repositoryId}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean deleteRemoteRepository(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;

    @Path(value="addRemoteRepository")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean addRemoteRepository(RemoteRepository var1) throws ArchivaRestServiceException;

    @Path(value="updateRemoteRepository")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean updateRemoteRepository(RemoteRepository var1) throws ArchivaRestServiceException;

    @Path(value="checkRemoteConnectivity/{repositoryId}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean checkRemoteConnectivity(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;
}

