/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.repository.scanner.RepositoryScanStatistics;
import org.apache.archiva.rest.api.model.ArtifactTransferRequest;
import org.apache.archiva.rest.api.model.StringList;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/repositoriesService/")
public interface RepositoriesService {
    @Path(value="scanRepository")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-run-indexer"})
    public Boolean scanRepository(@QueryParam(value="repositoryId") String var1, @QueryParam(value="fullScan") boolean var2) throws ArchivaRestServiceException;

    @Path(value="scanRepositoryDirectoriesNow/{repositoryId}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-run-indexer"})
    public RepositoryScanStatistics scanRepositoryDirectoriesNow(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;

    @Path(value="alreadyScanning/{repositoryId}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-run-indexer"})
    public Boolean alreadyScanning(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;

    @Path(value="removeScanningTaskFromQueue/{repositoryId}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-run-indexer"})
    public Boolean removeScanningTaskFromQueue(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;

    @Path(value="scanRepositoryNow")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-run-indexer"})
    public Boolean scanRepositoryNow(@QueryParam(value="repositoryId") String var1, @QueryParam(value="fullScan") boolean var2) throws ArchivaRestServiceException;

    @Path(value="copyArtifact")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noPermission=true)
    public Boolean copyArtifact(ArtifactTransferRequest var1) throws ArchivaRestServiceException;

    @Path(value="scheduleDownloadRemoteIndex")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-run-indexer"})
    public Boolean scheduleDownloadRemoteIndex(@QueryParam(value="repositoryId") String var1, @QueryParam(value="now") boolean var2, @QueryParam(value="fullDownload") boolean var3) throws ArchivaRestServiceException;

    @Path(value="deleteArtifact")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noPermission=true)
    public Boolean deleteArtifact(Artifact var1) throws ArchivaRestServiceException;

    @Path(value="projectVersion/{repositoryId}/{namespace}/{projectId}/{version}")
    @DELETE
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noPermission=true)
    public Boolean removeProjectVersion(@PathParam(value="repositoryId") String var1, @PathParam(value="namespace") String var2, @PathParam(value="projectId") String var3, @PathParam(value="version") String var4) throws ArchivaRestServiceException;

    @Path(value="isAuthorizedToDeleteArtifacts/{repositoryId}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public Boolean isAuthorizedToDeleteArtifacts(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;

    @Path(value="deleteGroupId")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noPermission=true)
    public Boolean deleteGroupId(@QueryParam(value="groupId") String var1, @QueryParam(value="repositoryId") String var2) throws ArchivaRestServiceException;

    @Path(value="project/{repositoryId}/{groupId}/{projectId}")
    @DELETE
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noPermission=true)
    public Boolean deleteProject(@PathParam(value="groupId") String var1, @PathParam(value="projectId") String var2, @PathParam(value="repositoryId") String var3) throws ArchivaRestServiceException;

    @Path(value="runningRemoteDownloadIds")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(noPermission=true)
    public StringList getRunningRemoteDownloadIds();
}

