/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/networkProxyService/")
public interface NetworkProxyService {
    @Path(value="getNetworkProxies")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<NetworkProxy> getNetworkProxies() throws ArchivaRestServiceException;

    @Path(value="getNetworkProxy/{networkProxyId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public NetworkProxy getNetworkProxy(@PathParam(value="networkProxyId") String var1) throws ArchivaRestServiceException;

    @Path(value="addNetworkProxy")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void addNetworkProxy(NetworkProxy var1) throws ArchivaRestServiceException;

    @Path(value="updateNetworkProxy")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public void updateNetworkProxy(NetworkProxy var1) throws ArchivaRestServiceException;

    @Path(value="deleteNetworkProxy/{networkProxyId}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean deleteNetworkProxy(@PathParam(value="networkProxyId") String var1) throws ArchivaRestServiceException;
}

