/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorAdmin;
import org.apache.archiva.policies.Policy;
import org.apache.archiva.rest.api.model.PolicyInformation;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.ProxyConnectorService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="proxyConnectorService#rest")
public class DefaultProxyConnectorService
extends AbstractRestService
implements ProxyConnectorService {
    @Inject
    private ProxyConnectorAdmin proxyConnectorAdmin;
    private List<Policy> allPolicies;

    @Inject
    public DefaultProxyConnectorService(ApplicationContext applicationContext) {
        this.allPolicies = new ArrayList<Policy>(this.getBeansOfType(applicationContext, Policy.class).values());
    }

    public List<ProxyConnector> getProxyConnectors() throws ArchivaRestServiceException {
        try {
            List proxyConnectors = this.proxyConnectorAdmin.getProxyConnectors();
            return proxyConnectors == null ? Collections.emptyList() : proxyConnectors;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public ProxyConnector getProxyConnector(String sourceRepoId, String targetRepoId) throws ArchivaRestServiceException {
        try {
            return this.proxyConnectorAdmin.getProxyConnector(sourceRepoId, targetRepoId);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean addProxyConnector(ProxyConnector proxyConnector) throws ArchivaRestServiceException {
        if (proxyConnector == null) {
            return Boolean.FALSE;
        }
        try {
            return this.proxyConnectorAdmin.addProxyConnector(proxyConnector, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean deleteProxyConnector(ProxyConnector proxyConnector) throws ArchivaRestServiceException {
        if (proxyConnector == null) {
            return Boolean.FALSE;
        }
        try {
            return this.proxyConnectorAdmin.deleteProxyConnector(proxyConnector, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean removeProxyConnector(String sourceRepoId, String targetRepoId) throws ArchivaRestServiceException {
        ProxyConnector proxyConnector = this.getProxyConnector(sourceRepoId, targetRepoId);
        if (proxyConnector == null) {
            throw new ArchivaRestServiceException("proxyConnector with sourceRepoId:" + sourceRepoId + " and targetRepoId:" + targetRepoId + " not exists", null);
        }
        return this.deleteProxyConnector(proxyConnector);
    }

    public Boolean updateProxyConnector(ProxyConnector proxyConnector) throws ArchivaRestServiceException {
        if (proxyConnector == null) {
            return Boolean.FALSE;
        }
        try {
            return this.proxyConnectorAdmin.updateProxyConnector(proxyConnector, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<PolicyInformation> getAllPolicyInformations() throws ArchivaRestServiceException {
        ArrayList<PolicyInformation> policyInformations = new ArrayList<PolicyInformation>(this.allPolicies.size());
        for (Policy policy : this.allPolicies) {
            policyInformations.add(new PolicyInformation(policy.getOptions(), policy.getDefaultOption(), policy.getId(), policy.getName()));
        }
        return policyInformations;
    }

    public ProxyConnectorAdmin getProxyConnectorAdmin() {
        return this.proxyConnectorAdmin;
    }

    public void setProxyConnectorAdmin(ProxyConnectorAdmin proxyConnectorAdmin) {
        this.proxyConnectorAdmin = proxyConnectorAdmin;
    }
}

