/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.RemoteRepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="remoteRepositoriesService#rest")
public class DefaultRemoteRepositoriesService
extends AbstractRestService
implements RemoteRepositoriesService {
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;

    public List<RemoteRepository> getRemoteRepositories() throws ArchivaRestServiceException {
        try {
            List remoteRepositories = this.remoteRepositoryAdmin.getRemoteRepositories();
            return remoteRepositories == null ? Collections.emptyList() : remoteRepositories;
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public RemoteRepository getRemoteRepository(String repositoryId) throws ArchivaRestServiceException {
        List<RemoteRepository> remoteRepositories = this.getRemoteRepositories();
        for (RemoteRepository repository : remoteRepositories) {
            if (!StringUtils.equals((String)repositoryId, (String)repository.getId())) continue;
            return repository;
        }
        return null;
    }

    public Boolean deleteRemoteRepository(String repositoryId) throws Exception {
        try {
            return this.remoteRepositoryAdmin.deleteRemoteRepository(repositoryId, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public Boolean addRemoteRepository(RemoteRepository remoteRepository) throws Exception {
        try {
            return this.remoteRepositoryAdmin.addRemoteRepository(remoteRepository, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public Boolean updateRemoteRepository(RemoteRepository remoteRepository) throws Exception {
        try {
            return this.remoteRepositoryAdmin.updateRemoteRepository(remoteRepository, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }
}

