/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.admin.ArchivaAdministration;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.ChecksummedFile;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.maven2.MavenArtifactFacet;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.MetadataResolutionException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.TaskQueueException;
import org.apache.archiva.redback.system.DefaultSecuritySession;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.repository.events.RepositoryListener;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.repository.metadata.RepositoryMetadataWriter;
import org.apache.archiva.repository.scanner.RepositoryScanStatistics;
import org.apache.archiva.repository.scanner.RepositoryScanner;
import org.apache.archiva.repository.scanner.RepositoryScannerException;
import org.apache.archiva.rest.api.model.ArtifactTransferRequest;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.RepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.archiva.scheduler.ArchivaTaskScheduler;
import org.apache.archiva.scheduler.indexing.ArchivaIndexingTaskExecutor;
import org.apache.archiva.scheduler.indexing.ArtifactIndexingTask;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexException;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexScheduler;
import org.apache.archiva.scheduler.repository.model.RepositoryTask;
import org.apache.archiva.security.ArchivaSecurityException;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.context.IndexingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="repositoriesService#rest")
public class DefaultRepositoriesService
extends AbstractRestService
implements RepositoriesService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="taskExecutor#indexing")
    private ArchivaIndexingTaskExecutor archivaIndexingTaskExecutor;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    private MavenIndexerUtils mavenIndexerUtils;
    @Inject
    private SecuritySystem securitySystem;
    @Inject
    private RepositoryContentFactory repositoryFactory;
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private ArchivaTaskScheduler scheduler;
    @Inject
    private DownloadRemoteIndexScheduler downloadRemoteIndexScheduler;
    @Inject
    @Named(value="repositorySessionFactory")
    protected RepositorySessionFactory repositorySessionFactory;
    @Inject
    protected List<RepositoryListener> listeners = new ArrayList<RepositoryListener>();
    @Inject
    private RepositoryScanner repoScanner;
    private ChecksumAlgorithm[] algorithms = new ChecksumAlgorithm[]{ChecksumAlgorithm.SHA1, ChecksumAlgorithm.MD5};

    public Boolean scanRepository(String repositoryId, boolean fullScan) {
        return this.doScanRepository(repositoryId, fullScan);
    }

    public Boolean alreadyScanning(String repositoryId) {
        return this.repositoryTaskScheduler.isProcessingRepositoryTask(repositoryId);
    }

    public Boolean removeScanningTaskFromQueue(String repositoryId) {
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        try {
            return this.repositoryTaskScheduler.unQueueTask(task);
        }
        catch (TaskQueueException e) {
            this.log.error("failed to unschedule scanning of repo with id {}", (Object)repositoryId, (Object)e);
            return false;
        }
    }

    public Boolean scanRepositoryNow(String repositoryId, boolean fullScan) throws ArchivaRestServiceException {
        try {
            ManagedRepository repository = this.managedRepositoryAdmin.getManagedRepository(repositoryId);
            IndexingContext context = this.managedRepositoryAdmin.createIndexContext(repository);
            ArtifactIndexingTask task = new ArtifactIndexingTask(repository, null, ArtifactIndexingTask.Action.FINISH, context);
            task.setExecuteOnEntireRepo(true);
            task.setOnlyUpdate(!fullScan);
            this.archivaIndexingTaskExecutor.executeTask((Task)task);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean scheduleDownloadRemoteIndex(String repositoryId, boolean now, boolean fullDownload) throws ArchivaRestServiceException {
        try {
            this.downloadRemoteIndexScheduler.scheduleDownloadRemote(repositoryId, now, fullDownload);
        }
        catch (DownloadRemoteIndexException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        return Boolean.TRUE;
    }

    public Boolean copyArtifact(ArtifactTransferRequest artifactTransferRequest) throws ArchivaRestServiceException {
        boolean authz;
        String userName = this.getAuditInformation().getUser().getUsername();
        if (StringUtils.isBlank((String)userName)) {
            throw new ArchivaRestServiceException("copyArtifact call: userName not found", null);
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getRepositoryId())) {
            throw new ArchivaRestServiceException("copyArtifact call: sourceRepositoryId cannot be null", null);
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getTargetRepositoryId())) {
            throw new ArchivaRestServiceException("copyArtifact call: targetRepositoryId cannot be null", null);
        }
        ManagedRepository source = null;
        try {
            source = this.managedRepositoryAdmin.getManagedRepository(artifactTransferRequest.getRepositoryId());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        if (source == null) {
            throw new ArchivaRestServiceException("cannot find repository with id " + artifactTransferRequest.getRepositoryId(), null);
        }
        ManagedRepository target = null;
        try {
            target = this.managedRepositoryAdmin.getManagedRepository(artifactTransferRequest.getTargetRepositoryId());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        if (target == null) {
            throw new ArchivaRestServiceException("cannot find repository with id " + artifactTransferRequest.getTargetRepositoryId(), null);
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getGroupId())) {
            throw new ArchivaRestServiceException("groupId is mandatory", null);
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getArtifactId())) {
            throw new ArchivaRestServiceException("artifactId is mandatory", null);
        }
        if (StringUtils.isBlank((String)artifactTransferRequest.getVersion())) {
            throw new ArchivaRestServiceException("version is mandatory", null);
        }
        if (VersionUtil.isSnapshot((String)artifactTransferRequest.getVersion())) {
            throw new ArchivaRestServiceException("copy of SNAPSHOT not supported", null);
        }
        User user = null;
        try {
            user = this.securitySystem.getUserManager().findUser(userName);
        }
        catch (UserNotFoundException e) {
            throw new ArchivaRestServiceException("user " + userName + " not found", (Throwable)e);
        }
        catch (UserManagerException e) {
            throw new ArchivaRestServiceException("ArchivaRestServiceException:" + e.getMessage(), (Throwable)e);
        }
        AuthenticationResult authn = new AuthenticationResult(true, userName, null);
        DefaultSecuritySession securitySession = new DefaultSecuritySession(authn, user);
        try {
            authz = this.securitySystem.isAuthorized((SecuritySession)securitySession, "archiva-read-repository", artifactTransferRequest.getRepositoryId());
            if (!authz) {
                throw new ArchivaRestServiceException("not authorized to access repo:" + artifactTransferRequest.getRepositoryId(), null);
            }
        }
        catch (AuthorizationException e) {
            this.log.error("error reading permission: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        try {
            authz = this.securitySystem.isAuthorized((SecuritySession)securitySession, "archiva-upload-repository", artifactTransferRequest.getTargetRepositoryId());
            if (!authz) {
                throw new ArchivaRestServiceException("not authorized to write to repo:" + artifactTransferRequest.getTargetRepositoryId(), null);
            }
        }
        catch (AuthorizationException e) {
            this.log.error("error reading permission: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        ArtifactReference artifactReference = new ArtifactReference();
        artifactReference.setArtifactId(artifactTransferRequest.getArtifactId());
        artifactReference.setGroupId(artifactTransferRequest.getGroupId());
        artifactReference.setVersion(artifactTransferRequest.getVersion());
        artifactReference.setClassifier(artifactTransferRequest.getClassifier());
        String packaging = StringUtils.trim((String)artifactTransferRequest.getPackaging());
        artifactReference.setType(StringUtils.isEmpty((String)packaging) ? "jar" : packaging);
        try {
            ManagedRepositoryContent sourceRepository = this.repositoryFactory.getManagedRepositoryContent(artifactTransferRequest.getRepositoryId());
            String artifactSourcePath = sourceRepository.toPath(artifactReference);
            if (StringUtils.isEmpty((String)artifactSourcePath)) {
                this.log.error("cannot find artifact " + artifactTransferRequest.toString());
                throw new ArchivaRestServiceException("cannot find artifact " + artifactTransferRequest.toString(), null);
            }
            File artifactFile = new File(source.getLocation(), artifactSourcePath);
            if (!artifactFile.exists()) {
                this.log.error("cannot find artifact " + artifactTransferRequest.toString());
                throw new ArchivaRestServiceException("cannot find artifact " + artifactTransferRequest.toString(), null);
            }
            ManagedRepositoryContent targetRepository = this.repositoryFactory.getManagedRepositoryContent(artifactTransferRequest.getTargetRepositoryId());
            String artifactPath = targetRepository.toPath(artifactReference);
            int lastIndex = artifactPath.lastIndexOf(47);
            String path = artifactPath.substring(0, lastIndex);
            File targetPath = new File(target.getLocation(), path);
            Date lastUpdatedTimestamp = Calendar.getInstance().getTime();
            int newBuildNumber = 1;
            String timestamp = null;
            File versionMetadataFile = new File(targetPath, "maven-metadata.xml");
            ArchivaRepositoryMetadata versionMetadata = this.getMetadata(versionMetadataFile);
            if (!targetPath.exists()) {
                targetPath.mkdirs();
            }
            String filename = artifactPath.substring(lastIndex + 1);
            boolean fixChecksums = !this.archivaAdministration.getKnownContentConsumers().contains("create-missing-checksums");
            File targetFile = new File(targetPath, filename);
            if (targetFile.exists() && target.isBlockRedeployments()) {
                throw new ArchivaRestServiceException("artifact already exists in target repo: " + artifactTransferRequest.getTargetRepositoryId() + " and redeployment blocked", null);
            }
            this.copyFile(artifactFile, targetPath, filename, fixChecksums);
            this.queueRepositoryTask(target.getId(), targetFile);
            String pomFilename = filename;
            if (StringUtils.isNotBlank((String)artifactTransferRequest.getClassifier())) {
                pomFilename = StringUtils.remove((String)pomFilename, (String)("-" + artifactTransferRequest.getClassifier()));
            }
            pomFilename = FilenameUtils.removeExtension((String)pomFilename) + ".pom";
            File pomFile = new File(new File(source.getLocation(), artifactSourcePath.substring(0, artifactPath.lastIndexOf(47))), pomFilename);
            if (pomFile != null && pomFile.length() > 0L) {
                this.copyFile(pomFile, targetPath, pomFilename, fixChecksums);
                this.queueRepositoryTask(target.getId(), new File(targetPath, pomFilename));
            }
            if (!this.archivaAdministration.getKnownContentConsumers().contains("metadata-updater")) {
                this.updateProjectMetadata(targetPath.getAbsolutePath(), lastUpdatedTimestamp, timestamp, newBuildNumber, fixChecksums, artifactTransferRequest);
            }
            String msg = "Artifact '" + artifactTransferRequest.getGroupId() + ":" + artifactTransferRequest.getArtifactId() + ":" + artifactTransferRequest.getVersion() + "' was successfully deployed to repository '" + artifactTransferRequest.getTargetRepositoryId() + "'";
        }
        catch (RepositoryException e) {
            this.log.error("RepositoryException: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryAdminException e) {
            this.log.error("RepositoryAdminException: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("IOException: " + e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void queueRepositoryTask(String repositoryId, File localFile) {
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setResourceFile(localFile);
        task.setUpdateRelatedArtifacts(true);
        try {
            this.scheduler.queueTask((Task)task);
        }
        catch (TaskQueueException e) {
            this.log.error("Unable to queue repository task to execute consumers on resource file ['" + localFile.getName() + "'].");
        }
    }

    private ArchivaRepositoryMetadata getMetadata(File metadataFile) throws RepositoryMetadataException {
        ArchivaRepositoryMetadata metadata = new ArchivaRepositoryMetadata();
        if (metadataFile.exists()) {
            try {
                metadata = MavenMetadataReader.read((File)metadataFile);
            }
            catch (XMLException e) {
                throw new RepositoryMetadataException(e.getMessage(), (Throwable)e);
            }
        }
        return metadata;
    }

    private File getMetadata(String targetPath) {
        String artifactPath = targetPath.substring(0, targetPath.lastIndexOf(File.separatorChar));
        return new File(artifactPath, "maven-metadata.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File targetPath, String targetFilename, boolean fixChecksums) throws IOException {
        FileOutputStream out = new FileOutputStream(new File(targetPath, targetFilename));
        FileInputStream input = new FileInputStream(sourceFile);
        try {
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)input);
        }
        if (fixChecksums) {
            this.fixChecksums(new File(targetPath, targetFilename));
        }
    }

    private void fixChecksums(File file) {
        ChecksummedFile checksum = new ChecksummedFile(file);
        checksum.fixChecksums(this.algorithms);
    }

    private void updateProjectMetadata(String targetPath, Date lastUpdatedTimestamp, String timestamp, int buildNumber, boolean fixChecksums, ArtifactTransferRequest artifactTransferRequest) throws RepositoryMetadataException {
        List<String> availableVersions = new ArrayList<String>();
        String latestVersion = artifactTransferRequest.getVersion();
        File projectDir = new File(targetPath).getParentFile();
        File projectMetadataFile = new File(projectDir, "maven-metadata.xml");
        ArchivaRepositoryMetadata projectMetadata = this.getMetadata(projectMetadataFile);
        if (projectMetadataFile.exists()) {
            availableVersions = projectMetadata.getAvailableVersions();
            Collections.sort(availableVersions, VersionComparator.getInstance());
            if (!availableVersions.contains(artifactTransferRequest.getVersion())) {
                availableVersions.add(artifactTransferRequest.getVersion());
            }
            latestVersion = (String)availableVersions.get(availableVersions.size() - 1);
        } else {
            availableVersions.add(artifactTransferRequest.getVersion());
            projectMetadata.setGroupId(artifactTransferRequest.getGroupId());
            projectMetadata.setArtifactId(artifactTransferRequest.getArtifactId());
        }
        if (projectMetadata.getGroupId() == null) {
            projectMetadata.setGroupId(artifactTransferRequest.getGroupId());
        }
        if (projectMetadata.getArtifactId() == null) {
            projectMetadata.setArtifactId(artifactTransferRequest.getArtifactId());
        }
        projectMetadata.setLatestVersion(latestVersion);
        projectMetadata.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        projectMetadata.setAvailableVersions(availableVersions);
        if (!VersionUtil.isSnapshot((String)artifactTransferRequest.getVersion())) {
            projectMetadata.setReleasedVersion(latestVersion);
        }
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)projectMetadata, (File)projectMetadataFile);
        if (fixChecksums) {
            this.fixChecksums(projectMetadataFile);
        }
    }

    public Boolean removeProjectVersion(String repositoryId, String namespace, String projectId, String version) throws ArchivaRestServiceException {
        if (!VersionUtil.isGenericSnapshot((String)version)) {
            Artifact artifact = new Artifact(namespace, projectId, version);
            return this.deleteArtifact(artifact);
        }
        if (StringUtils.isEmpty((String)repositoryId)) {
            throw new ArchivaRestServiceException("repositoryId cannot be null", 400, null);
        }
        if (!this.isAuthorizedToDeleteArtifacts(repositoryId).booleanValue()) {
            throw new ArchivaRestServiceException("not authorized to delete artifacts", 403, null);
        }
        if (StringUtils.isEmpty((String)namespace)) {
            throw new ArchivaRestServiceException("groupId cannot be null", 400, null);
        }
        if (StringUtils.isEmpty((String)projectId)) {
            throw new ArchivaRestServiceException("artifactId cannot be null", 400, null);
        }
        if (StringUtils.isEmpty((String)version)) {
            throw new ArchivaRestServiceException("version cannot be null", 400, null);
        }
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        try {
            ManagedRepositoryContent repository = this.repositoryFactory.getManagedRepositoryContent(repositoryId);
            VersionedReference ref = new VersionedReference();
            ref.setArtifactId(projectId);
            ref.setGroupId(namespace);
            ref.setVersion(version);
            repository.deleteVersion(ref);
            ArtifactReference artifactReference = new ArtifactReference();
            artifactReference.setGroupId(namespace);
            artifactReference.setArtifactId(projectId);
            artifactReference.setVersion(version);
            MetadataRepository metadataRepository = repositorySession.getRepository();
            Set related = repository.getRelatedArtifacts(artifactReference);
            this.log.debug("related: {}", (Object)related);
            for (ArtifactReference artifactRef : related) {
                repository.deleteArtifact(artifactRef);
            }
            Collection artifacts = metadataRepository.getArtifacts(repositoryId, namespace, projectId, version);
            for (ArtifactMetadata artifactMetadata : artifacts) {
                metadataRepository.removeArtifact(artifactMetadata, version);
            }
            metadataRepository.removeProjectVersion(repositoryId, namespace, projectId, version);
        }
        catch (MetadataRepositoryException e) {
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        catch (MetadataResolutionException e) {
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        finally {
            repositorySession.save();
            repositorySession.close();
        }
        return Boolean.TRUE;
    }

    public Boolean deleteArtifact(Artifact artifact) throws ArchivaRestServiceException {
        String repositoryId = artifact.getContext();
        if (StringUtils.isEmpty((String)repositoryId)) {
            throw new ArchivaRestServiceException("repositoryId cannot be null", 400, null);
        }
        if (!this.isAuthorizedToDeleteArtifacts(repositoryId).booleanValue()) {
            throw new ArchivaRestServiceException("not authorized to delete artifacts", 403, null);
        }
        if (artifact == null) {
            throw new ArchivaRestServiceException("artifact cannot be null", 400, null);
        }
        if (StringUtils.isEmpty((String)artifact.getGroupId())) {
            throw new ArchivaRestServiceException("artifact.groupId cannot be null", 400, null);
        }
        if (StringUtils.isEmpty((String)artifact.getArtifactId())) {
            throw new ArchivaRestServiceException("artifact.artifactId cannot be null", 400, null);
        }
        boolean snapshotVersion = VersionUtil.isSnapshot((String)artifact.getVersion()) | VersionUtil.isGenericSnapshot((String)artifact.getVersion());
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        try {
            Collection projectVersions;
            Date lastUpdatedTimestamp = Calendar.getInstance().getTime();
            TimeZone timezone = TimeZone.getTimeZone("UTC");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd.HHmmss");
            fmt.setTimeZone(timezone);
            ManagedRepository repoConfig = this.managedRepositoryAdmin.getManagedRepository(repositoryId);
            VersionedReference ref = new VersionedReference();
            ref.setArtifactId(artifact.getArtifactId());
            ref.setGroupId(artifact.getGroupId());
            ref.setVersion(artifact.getVersion());
            ManagedRepositoryContent repository = this.repositoryFactory.getManagedRepositoryContent(repositoryId);
            ArtifactReference artifactReference = new ArtifactReference();
            artifactReference.setArtifactId(artifact.getArtifactId());
            artifactReference.setGroupId(artifact.getGroupId());
            artifactReference.setVersion(artifact.getVersion());
            artifactReference.setClassifier(artifact.getClassifier());
            artifactReference.setType(artifact.getPackaging());
            MetadataRepository metadataRepository = repositorySession.getRepository();
            String path = repository.toMetadataPath(ref);
            if (StringUtils.isNotBlank((String)artifact.getClassifier())) {
                if (StringUtils.isBlank((String)artifact.getPackaging())) {
                    throw new ArchivaRestServiceException("You must configure a type/packaging when using classifier", 400, null);
                }
                repository.deleteArtifact(artifactReference);
            } else {
                int index = path.lastIndexOf(47);
                path = path.substring(0, index);
                File targetPath = new File(repoConfig.getLocation(), path);
                if (!targetPath.exists()) {
                    this.log.warn("targetPath {} not found skip file deletion", (Object)targetPath);
                }
                if (!snapshotVersion) {
                    repository.deleteVersion(ref);
                } else {
                    Set set = repository.getRelatedArtifacts(artifactReference);
                    this.log.debug("related: {}", (Object)set);
                    for (ArtifactReference artifactRef : set) {
                        repository.deleteArtifact(artifactRef);
                    }
                }
                File file = this.getMetadata(targetPath.getAbsolutePath());
                ArchivaRepositoryMetadata metadata = this.getMetadata(file);
                this.updateMetadata(metadata, file, lastUpdatedTimestamp, artifact);
            }
            Collection<Object> artifacts = Collections.emptyList();
            if (snapshotVersion) {
                String baseVersion = VersionUtil.getBaseVersion((String)artifact.getVersion());
                artifacts = metadataRepository.getArtifacts(repositoryId, artifact.getGroupId(), artifact.getArtifactId(), baseVersion);
            } else {
                artifacts = metadataRepository.getArtifacts(repositoryId, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            }
            this.log.debug("artifacts: {}", artifacts);
            if (artifacts.isEmpty() && !snapshotVersion && (projectVersions = metadataRepository.getProjectVersions(repositoryId, artifact.getGroupId(), artifact.getArtifactId())).contains(artifact.getVersion())) {
                this.log.warn("artifact not found when deleted but version still here ! so force cleanup");
                metadataRepository.removeProjectVersion(repositoryId, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            }
            for (ArtifactMetadata artifactMetadata : artifacts) {
                if (!artifactMetadata.getVersion().equals(artifact.getVersion())) continue;
                if (StringUtils.isNotBlank((String)artifact.getClassifier())) {
                    if (StringUtils.isBlank((String)artifact.getPackaging())) {
                        throw new ArchivaRestServiceException("You must configure a type/packaging when using classifier", 400, null);
                    }
                    MavenArtifactFacet mavenArtifactFacet = (MavenArtifactFacet)artifactMetadata.getFacet("org.apache.archiva.metadata.repository.storage.maven2.artifact");
                    if (StringUtils.equals((String)artifact.getClassifier(), (String)mavenArtifactFacet.getClassifier())) {
                        artifactMetadata.removeFacet("org.apache.archiva.metadata.repository.storage.maven2.artifact");
                        String groupId = artifact.getGroupId();
                        String artifactId = artifact.getArtifactId();
                        String version = artifact.getVersion();
                        MavenArtifactFacet mavenArtifactFacetToCompare = new MavenArtifactFacet();
                        mavenArtifactFacetToCompare.setClassifier(artifact.getClassifier());
                        metadataRepository.removeArtifact(repositoryId, groupId, artifactId, version, (MetadataFacet)mavenArtifactFacetToCompare);
                        metadataRepository.save();
                    }
                } else if (snapshotVersion) {
                    metadataRepository.removeArtifact(artifactMetadata, VersionUtil.getBaseVersion((String)artifact.getVersion()));
                } else {
                    metadataRepository.removeArtifact(artifactMetadata.getRepositoryId(), artifactMetadata.getNamespace(), artifactMetadata.getProject(), artifact.getVersion(), artifactMetadata.getId());
                }
                for (RepositoryListener listener : this.listeners) {
                    listener.deleteArtifact(metadataRepository, repository.getId(), artifactMetadata.getNamespace(), artifactMetadata.getProject(), artifactMetadata.getVersion(), artifactMetadata.getId());
                }
                this.triggerAuditEvent(repositoryId, path, "Removed File");
            }
        }
        catch (ContentNotFoundException e) {
            throw new ArchivaRestServiceException("Artifact does not exist: " + e.getMessage(), 400, (Throwable)e);
        }
        catch (RepositoryNotFoundException e) {
            throw new ArchivaRestServiceException("Target repository cannot be found: " + e.getMessage(), 400, (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        catch (MetadataResolutionException e) {
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        catch (MetadataRepositoryException e) {
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException("RepositoryAdmin exception: " + e.getMessage(), 500, (Throwable)e);
        }
        finally {
            repositorySession.save();
            repositorySession.close();
        }
        return Boolean.TRUE;
    }

    public Boolean deleteGroupId(String groupId, String repositoryId) throws ArchivaRestServiceException {
        if (StringUtils.isEmpty((String)repositoryId)) {
            throw new ArchivaRestServiceException("repositoryId cannot be null", 400, null);
        }
        if (!this.isAuthorizedToDeleteArtifacts(repositoryId).booleanValue()) {
            throw new ArchivaRestServiceException("not authorized to delete artifacts", 403, null);
        }
        if (StringUtils.isEmpty((String)groupId)) {
            throw new ArchivaRestServiceException("groupId cannot be null", 400, null);
        }
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        try {
            ManagedRepositoryContent repository = this.repositoryFactory.getManagedRepositoryContent(repositoryId);
            repository.deleteGroupId(groupId);
            MetadataRepository metadataRepository = repositorySession.getRepository();
            metadataRepository.removeNamespace(repositoryId, groupId);
            metadataRepository.save();
        }
        catch (MetadataRepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        finally {
            repositorySession.close();
        }
        return true;
    }

    public Boolean deleteProject(String groupId, String projectId, String repositoryId) throws ArchivaRestServiceException {
        if (StringUtils.isEmpty((String)repositoryId)) {
            throw new ArchivaRestServiceException("repositoryId cannot be null", 400, null);
        }
        if (!this.isAuthorizedToDeleteArtifacts(repositoryId).booleanValue()) {
            throw new ArchivaRestServiceException("not authorized to delete artifacts", 403, null);
        }
        if (StringUtils.isEmpty((String)groupId)) {
            throw new ArchivaRestServiceException("groupId cannot be null", 400, null);
        }
        if (StringUtils.isEmpty((String)projectId)) {
            throw new ArchivaRestServiceException("artifactId cannot be null", 400, null);
        }
        RepositorySession repositorySession = this.repositorySessionFactory.createSession();
        try {
            ManagedRepositoryContent repository = this.repositoryFactory.getManagedRepositoryContent(repositoryId);
            repository.deleteProject(groupId, projectId);
        }
        catch (ContentNotFoundException e) {
            this.log.warn("skip ContentNotFoundException: {}", (Object)e.getMessage());
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        try {
            MetadataRepository metadataRepository = repositorySession.getRepository();
            metadataRepository.removeProject(repositoryId, groupId, projectId);
            metadataRepository.save();
        }
        catch (MetadataRepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException("Repository exception: " + e.getMessage(), 500, (Throwable)e);
        }
        finally {
            repositorySession.close();
        }
        return true;
    }

    public Boolean isAuthorizedToDeleteArtifacts(String repoId) throws ArchivaRestServiceException {
        String userName = this.getAuditInformation().getUser() == null ? "guest" : this.getAuditInformation().getUser().getUsername();
        try {
            return this.userRepositories.isAuthorizedToDeleteArtifacts(userName, repoId);
        }
        catch (ArchivaSecurityException e) {
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    public RepositoryScanStatistics scanRepositoryDirectoriesNow(String repositoryId) throws ArchivaRestServiceException {
        long sinceWhen = 0L;
        try {
            return this.repoScanner.scan(this.getManagedRepositoryAdmin().getManagedRepository(repositoryId), sinceWhen);
        }
        catch (RepositoryScannerException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException("RepositoryScannerException exception: " + e.getMessage(), 500, (Throwable)e);
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException("RepositoryScannerException exception: " + e.getMessage(), 500, (Throwable)e);
        }
    }

    private void updateMetadata(ArchivaRepositoryMetadata metadata, File metadataFile, Date lastUpdatedTimestamp, Artifact artifact) throws RepositoryMetadataException {
        List availableVersions = new ArrayList();
        String latestVersion = "";
        if (metadataFile.exists() && metadata.getAvailableVersions() != null && (availableVersions = metadata.getAvailableVersions()).size() > 0) {
            Collections.sort(availableVersions, VersionComparator.getInstance());
            if (availableVersions.contains(artifact.getVersion())) {
                availableVersions.remove(availableVersions.indexOf(artifact.getVersion()));
            }
            if (availableVersions.size() > 0) {
                latestVersion = (String)availableVersions.get(availableVersions.size() - 1);
            }
        }
        if (metadata.getGroupId() == null) {
            metadata.setGroupId(artifact.getGroupId());
        }
        if (metadata.getArtifactId() == null) {
            metadata.setArtifactId(artifact.getArtifactId());
        }
        if (!VersionUtil.isSnapshot((String)artifact.getVersion()) && metadata.getReleasedVersion() != null && metadata.getReleasedVersion().equals(artifact.getVersion())) {
            metadata.setReleasedVersion(latestVersion);
        }
        metadata.setLatestVersion(latestVersion);
        metadata.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        metadata.setAvailableVersions(availableVersions);
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)metadata, (File)metadataFile);
        ChecksummedFile checksum = new ChecksummedFile(metadataFile);
        checksum.fixChecksums(this.algorithms);
    }

    public ManagedRepositoryAdmin getManagedRepositoryAdmin() {
        return this.managedRepositoryAdmin;
    }

    public void setManagedRepositoryAdmin(ManagedRepositoryAdmin managedRepositoryAdmin) {
        this.managedRepositoryAdmin = managedRepositoryAdmin;
    }

    public RepositoryContentFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(RepositoryContentFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public RepositorySessionFactory getRepositorySessionFactory() {
        return this.repositorySessionFactory;
    }

    public void setRepositorySessionFactory(RepositorySessionFactory repositorySessionFactory) {
        this.repositorySessionFactory = repositorySessionFactory;
    }

    public List<RepositoryListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<RepositoryListener> listeners) {
        this.listeners = listeners;
    }

    public ArchivaAdministration getArchivaAdministration() {
        return this.archivaAdministration;
    }

    public void setArchivaAdministration(ArchivaAdministration archivaAdministration) {
        this.archivaAdministration = archivaAdministration;
    }
}

