/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.security.AccessDeniedException;
import org.apache.maven.archiva.security.ArchivaSecurityException;
import org.apache.maven.archiva.security.PrincipalNotFoundException;
import org.apache.maven.archiva.security.UserRepositories;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUserRepositories
implements UserRepositories {
    private SecuritySystem securitySystem;
    private RBACManager rbacManager;
    private RoleManager roleManager;
    private ArchivaConfiguration archivaConfiguration;

    @Override
    public List<String> getObservableRepositoryIds(String principal) throws PrincipalNotFoundException, AccessDeniedException, ArchivaSecurityException {
        try {
            User user = this.securitySystem.getUserManager().findUser(principal);
            if (user.isLocked()) {
                throw new AccessDeniedException("User " + principal + "(" + user.getFullName() + ") is locked.");
            }
            AuthenticationResult authn = new AuthenticationResult(true, (Object)principal, null);
            DefaultSecuritySession securitySession = new DefaultSecuritySession(authn, user);
            ArrayList<String> repoIds = new ArrayList<String>();
            List repos = this.archivaConfiguration.getConfiguration().getManagedRepositories();
            for (ManagedRepositoryConfiguration repo : repos) {
                try {
                    String repoId = repo.getId();
                    if (!this.securitySystem.isAuthorized((SecuritySession)securitySession, (Object)"archiva-read-repository", (Object)repoId)) continue;
                    repoIds.add(repoId);
                }
                catch (AuthorizationException e) {}
            }
            return repoIds;
        }
        catch (UserNotFoundException e) {
            throw new PrincipalNotFoundException("Unable to find principal " + principal + "");
        }
    }

    @Override
    public void createMissingRepositoryRoles(String repoId) throws ArchivaSecurityException {
        try {
            if (!this.roleManager.templatedRoleExists("archiva-repository-observer", repoId)) {
                this.roleManager.createTemplatedRole("archiva-repository-observer", repoId);
            }
            if (!this.roleManager.templatedRoleExists("archiva-repository-manager", repoId)) {
                this.roleManager.createTemplatedRole("archiva-repository-manager", repoId);
            }
        }
        catch (RoleManagerException e) {
            throw new ArchivaSecurityException("Unable to create roles for configured repositories: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isAuthorizedToUploadArtifacts(String principal, String repoId) throws PrincipalNotFoundException, ArchivaSecurityException {
        try {
            User user = this.securitySystem.getUserManager().findUser(principal);
            if (user.isLocked()) {
                throw new AccessDeniedException("User " + principal + "(" + user.getFullName() + ") is locked.");
            }
            AuthenticationResult authn = new AuthenticationResult(true, (Object)principal, null);
            DefaultSecuritySession securitySession = new DefaultSecuritySession(authn, user);
            return this.securitySystem.isAuthorized((SecuritySession)securitySession, (Object)"archiva-upload-repository", (Object)repoId);
        }
        catch (UserNotFoundException e) {
            throw new PrincipalNotFoundException("Unable to find principal " + principal + "");
        }
        catch (AuthorizationException e) {
            throw new ArchivaSecurityException(e.getMessage());
        }
    }
}

