/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.archiva.common.ArchivaException;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ConfigurationNames;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.security.ArchivaRoleConstants;
import org.apache.maven.archiva.security.ArchivaSecurityException;
import org.apache.maven.archiva.security.UserRepositories;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityStartup
implements RegistryListener {
    private Logger log = LoggerFactory.getLogger(SecurityStartup.class);
    private UserRepositories userRepos;
    private RBACManager rbacManager;
    private Map<String, EnvironmentCheck> checkers;
    private ArchivaConfiguration archivaConfiguration;

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isManagedRepositories((String)propertyName)) {
            this.createMissingManagedRepositoryRoles(this.archivaConfiguration.getConfiguration().getManagedRepositories());
        }
    }

    public void assignRepositoryObserverToGuestUser(List<ManagedRepositoryConfiguration> repos) {
        for (ManagedRepositoryConfiguration repoConfig : repos) {
            String repoId = repoConfig.getId();
            String principal = "guest";
            try {
                UserAssignment ua = this.rbacManager.userAssignmentExists(principal) ? this.rbacManager.getUserAssignment(principal) : this.rbacManager.createUserAssignment(principal);
                ua.addRoleName(ArchivaRoleConstants.toRepositoryObserverRoleName(repoId));
                this.rbacManager.saveUserAssignment(ua);
            }
            catch (RbacManagerException e) {
                this.log.warn("Unable to add role [" + ArchivaRoleConstants.toRepositoryObserverRoleName(repoId) + "] to " + principal + " user.", (Throwable)e);
            }
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    public void createMissingManagedRepositoryRoles(List<ManagedRepositoryConfiguration> repos) {
        for (ManagedRepositoryConfiguration repoConfig : repos) {
            try {
                this.userRepos.createMissingRepositoryRoles(repoConfig.getId());
            }
            catch (ArchivaSecurityException e) {
                this.log.warn(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    public void createMissingRepositoryRoles(List<String> repoIds) {
        for (String repoId : repoIds) {
            try {
                this.userRepos.createMissingRepositoryRoles(repoId);
            }
            catch (ArchivaSecurityException e) {
                this.log.warn(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    public void executeEnvironmentChecks() throws ArchivaException {
        if (this.checkers == null || CollectionUtils.isEmpty(this.checkers.values())) {
            throw new ArchivaException("Unable to initialize the Redback Security Environment, no Environment Check components found.");
        }
        ArrayList violations = new ArrayList();
        for (Map.Entry<String, EnvironmentCheck> entry : this.checkers.entrySet()) {
            EnvironmentCheck check = entry.getValue();
            this.log.info("Running Environment Check: " + entry.getKey());
            check.validateEnvironment(violations);
        }
        if (CollectionUtils.isNotEmpty(violations)) {
            StringBuffer msg = new StringBuffer();
            msg.append("EnvironmentCheck Failure.\n");
            msg.append("======================================================================\n");
            msg.append(" ENVIRONMENT FAILURE !! \n");
            msg.append("\n");
            for (String violation : violations) {
                msg.append(violation).append("\n");
            }
            msg.append("\n");
            msg.append("======================================================================");
            this.log.error(msg.toString());
            throw new ArchivaException("Unable to initialize Redback Security Environment, [" + violations.size() + "] violation(s) encountered, See log for details.");
        }
    }

    public void startup() throws ArchivaException {
        this.executeEnvironmentChecks();
        this.createMissingManagedRepositoryRoles(this.archivaConfiguration.getConfiguration().getManagedRepositories());
        this.archivaConfiguration.addChangeListener((RegistryListener)this);
        if (this.archivaConfiguration.isDefaulted()) {
            this.assignRepositoryObserverToGuestUser(this.archivaConfiguration.getConfiguration().getManagedRepositories());
        }
    }
}

