/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.maven.archiva.security.ServletAuthenticator;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.authorization.AuthorizationResult;
import org.codehaus.plexus.redback.authorization.UnauthorizedException;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivaServletAuthenticator
implements ServletAuthenticator {
    private Logger log = LoggerFactory.getLogger(ArchivaServletAuthenticator.class);
    private SecuritySystem securitySystem;

    public boolean isAuthenticated(HttpServletRequest request, AuthenticationResult result) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        if (result != null && !result.isAuthenticated()) {
            throw new AuthenticationException("User Credentials Invalid");
        }
        return true;
    }

    public boolean isAuthorized(HttpServletRequest request, SecuritySession securitySession, String repositoryId, String permission) throws AuthorizationException, UnauthorizedException {
        AuthorizationResult authzResult = this.securitySystem.authorize(securitySession, (Object)permission, (Object)repositoryId);
        if (!authzResult.isAuthorized()) {
            if (authzResult.getException() != null) {
                this.log.info("Authorization Denied [ip=" + request.getRemoteAddr() + ",permission=" + permission + ",repo=" + repositoryId + "] : " + authzResult.getException().getMessage());
                throw new UnauthorizedException("Access denied for repository " + repositoryId);
            }
            throw new UnauthorizedException("User account is locked");
        }
        return true;
    }

    public boolean isAuthorized(String principal, String repoId, String permission) throws UnauthorizedException {
        try {
            User user = this.securitySystem.getUserManager().findUser(principal);
            if (user == null) {
                throw new UnauthorizedException("The security system had an internal error - please check your system logs");
            }
            if (user.isLocked()) {
                throw new UnauthorizedException("User account is locked.");
            }
            AuthenticationResult authn = new AuthenticationResult(true, (Object)principal, null);
            DefaultSecuritySession securitySession = new DefaultSecuritySession(authn, user);
            return this.securitySystem.isAuthorized((SecuritySession)securitySession, (Object)permission, (Object)repoId);
        }
        catch (UserNotFoundException e) {
            throw new UnauthorizedException(e.getMessage());
        }
        catch (AuthorizationException e) {
            throw new UnauthorizedException(e.getMessage());
        }
    }
}

